# Changelog

All notable changes to the Fixture Manager daemon project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.2.0] - 2025-08-21

### Added
- **New `/api/updates` endpoint** for incremental fixture data synchronization
  - Supports both GET and POST HTTP methods
  - Optional `from` parameter for timestamp-based filtering
  - Returns fixtures updated after specified unix timestamp
  - Configurable default count when no `from` parameter provided
  - Includes ZIP download URLs in API response
- **Fixture active time tracking** with automatic timestamp management
  - New `fixture_active_time` column in matches table (BigInteger, indexed)
  - Automatic timestamp setting when all matches in fixture become active
  - Preserves original activation time (no overwrites)
- **Hybrid authentication system** for maximum compatibility
  - Supports JWT tokens (short-lived, from login)
  - Supports API tokens (long-lived, from web interface)
  - Tries JWT first, falls back to API tokens automatically
  - Multiple token header formats supported
- **System settings integration** for configurable behavior
  - New `api_updates_default_count` setting (default: 10)
  - Configurable via web interface
  - Proper type conversion and fallback handling
- **SHA1-based ZIP file naming** for consistency
  - Uses SHA1 hash of (unix_timestamp + original_filename)
  - Applied across all upload methods (regular and streaming)
  - Maintains compatibility with existing download infrastructure
- **Data backfill utility** for existing fixtures
  - `backfill_fixture_times.py` script for one-time data migration
  - Automatically sets fixture_active_time for existing active fixtures
  - Comprehensive logging and progress reporting
- **Fallback mechanisms** for robustness
  - Automatic fallback to active_status queries when fixture_active_time is null
  - Graceful degradation for existing data without timestamps
  - Error handling and logging for all edge cases

### Enhanced
- **Database migration system** with new Migration_005
  - Added fixture_active_time column with proper indexing
  - Python 2.7 compatibility fixes (no f-strings)
  - Custom migration runner script for easier execution
- **API authentication flexibility** 
  - Authorization header (`Bearer token`)
  - X-API-Token header
  - Query parameter support (less secure, but available)
- **Query optimization and limits**
  - Both default and filtered queries respect configurable limits
  - Proper ordering (ascending for 'from' queries, descending for default)
  - Efficient database queries with appropriate indexes
- **Logging improvements**
  - Fixed import errors in models.py
  - Consistent logging across all new features
  - Proper error handling and debug information

### Fixed
- **Import errors** in models.py (get_logger function)
- **Python 2.7 compatibility** in migration scripts
- **Type conversion issues** in SystemSettings.get_setting()
- **Query performance** with proper indexing and limits

### Technical Details
- **Database Schema**: Added fixture_active_time column (BigInteger, nullable, indexed)
- **API Endpoints**: New `/api/updates` with comprehensive functionality
- **Authentication**: Dual-mode JWT/API token support with automatic fallback
- **File Operations**: SHA1-based naming for all ZIP uploads
- **Configuration**: New system setting for API behavior customization
- **Migration**: Version 005 for schema updates with proper rollback support

### Security
- All authentication methods maintain existing security standards
- API token validation and JWT verification unchanged
- Proper input validation for all new parameters
- Rate limiting and access controls remain in effect

---

## [1.1.0] - 2025-08-18

### Added
- ✅ **API Token Management**: Complete user-generated token system
- ✅ **Enhanced Security**: SHA256 token hashing with usage tracking
- ✅ **Web Interface**: Professional token management UI
- ✅ **Multiple Auth Methods**: Bearer tokens, headers, and query parameters
- ✅ **Token Lifecycle**: Create, revoke, extend, and delete operations
- ✅ **Usage Monitoring**: Last used timestamps and IP tracking
- ✅ **Database Migration**: Automatic schema updates with versioning
- ✅ **REST API Endpoints**: Protected fixture and match data access
- ✅ **Documentation**: Comprehensive API and security guidelines

---

## [1.0.0] - 2025-08-01

### Added
- Initial release of Fixture Manager daemon
- Secure web dashboard with authentication
- RESTful API with JWT authentication
- MySQL database integration
- Advanced file upload system with progress tracking
- Dual-format support (CSV/XLSX)
- Two-stage upload workflow
- Daemon process management with systemd integration
- Security features and validation
- Comprehensive documentation