#!/usr/bin/env python

import os
import sys

# Add the project directory to Python path
sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))

def run_migration():
    """Simple migration runner script"""
    try:
        # Set environment variable for Flask
        os.environ['FLASK_ENV'] = 'development'
        
        # Import Flask app
        from app import create_app, db
        
        # Create app context
        app = create_app()
        
        with app.app_context():
            print("Creating database tables...")
            db.create_all()
            
            print("Running migrations...")
            from app.database.migrations import run_migrations
            result = run_migrations()
            
            print("Migration result:", result)
            
            if result['status'] == 'success':
                print("SUCCESS: All migrations completed successfully!")
                return True
            elif result['status'] == 'partial':
                print("PARTIAL: Some migrations failed")
                print("Applied:", result.get('applied_count', 0))
                print("Failed:", result.get('failed_count', 0))
                return False
            else:
                print("ERROR: Migration failed")
                return False
            
    except Exception as e:
        print("ERROR: Migration failed with exception:", str(e))
        import traceback
        traceback.print_exc()
        return False

if __name__ == '__main__':
    success = run_migration()
    sys.exit(0 if success else 1)