"""Migration to allow match_number to be null in bets, bet_details, extraction_stats, and match_reports tables."""

from app.database import manager
from app import db

def upgrade():
    """Upgrade the database to allow match_number to be null."""
    with manager.get_alembic_context().begin_transaction():
        # Alter bets table
        db.engine.execute('ALTER TABLE bets MODIFY match_number INT NULL')
        # Alter bet_details table
        db.engine.execute('ALTER TABLE bet_details MODIFY match_number INT NULL')
        # Alter extraction_stats table
        db.engine.execute('ALTER TABLE extraction_stats MODIFY match_number INT NULL')
        # Alter match_reports table
        db.engine.execute('ALTER TABLE match_reports MODIFY match_number INT NULL')

def downgrade():
    """Downgrade the database to make match_number not null."""
    with manager.get_alembic_context().begin_transaction():
        # Alter bets table
        db.engine.execute('ALTER TABLE bets MODIFY match_number INT NOT NULL')
        # Alter bet_details table
        db.engine.execute('ALTER TABLE bet_details MODIFY match_number INT NOT NULL')
        # Alter extraction_stats table
        db.engine.execute('ALTER TABLE extraction_stats MODIFY match_number INT NOT NULL')
        # Alter match_reports table
        db.engine.execute('ALTER TABLE match_reports MODIFY match_number INT NOT NULL')