"""
Migration to add accumulated_shortfall and cap_percentage fields to match_reports and extraction_stats tables
"""
from app import db

def upgrade():
    """Add accumulated_shortfall and cap_percentage columns to match_reports and extraction_stats tables"""
    try:
        # Check if columns already exist in match_reports
        inspector = db.inspect(db.engine)
        match_reports_columns = [col['name'] for col in inspector.get_columns('match_reports')]
        
        if 'accumulated_shortfall' not in match_reports_columns:
            # Add accumulated_shortfall column to match_reports
            with db.engine.connect() as conn:
                conn.execute(db.text("""
                    ALTER TABLE match_reports 
                    ADD COLUMN accumulated_shortfall NUMERIC(15, 2) DEFAULT 0.00
                """))
            db.session.commit()
            print("✓ Added accumulated_shortfall column to match_reports table")
        else:
            print("✓ accumulated_shortfall column already exists in match_reports table")
        
        if 'cap_percentage' not in match_reports_columns:
            # Add cap_percentage column to match_reports
            with db.engine.connect() as conn:
                conn.execute(db.text("""
                    ALTER TABLE match_reports 
                    ADD COLUMN cap_percentage NUMERIC(5, 2)
                """))
            db.session.commit()
            print("✓ Added cap_percentage column to match_reports table")
        else:
            print("✓ cap_percentage column already exists in match_reports table")
        
        # Check if columns already exist in extraction_stats
        extraction_stats_columns = [col['name'] for col in inspector.get_columns('extraction_stats')]
        
        if 'accumulated_shortfall' not in extraction_stats_columns:
            # Add accumulated_shortfall column to extraction_stats
            with db.engine.connect() as conn:
                conn.execute(db.text("""
                    ALTER TABLE extraction_stats 
                    ADD COLUMN accumulated_shortfall NUMERIC(15, 2) DEFAULT 0.00
                """))
            db.session.commit()
            print("✓ Added accumulated_shortfall column to extraction_stats table")
        else:
            print("✓ accumulated_shortfall column already exists in extraction_stats table")
        
        if 'cap_percentage' not in extraction_stats_columns:
            # Add cap_percentage column to extraction_stats
            with db.engine.connect() as conn:
                conn.execute(db.text("""
                    ALTER TABLE extraction_stats 
                    ADD COLUMN cap_percentage NUMERIC(5, 2)
                """))
            db.session.commit()
            print("✓ Added cap_percentage column to extraction_stats table")
        else:
            print("✓ cap_percentage column already exists in extraction_stats table")
            
    except Exception as e:
        db.session.rollback()
        print(f"✗ Error adding columns: {str(e)}")
        raise

def downgrade():
    """Remove accumulated_shortfall and cap_percentage columns from match_reports and extraction_stats tables"""
    try:
        # Remove columns from match_reports table
        with db.engine.connect() as conn:
            conn.execute(db.text("""
                ALTER TABLE match_reports 
                DROP COLUMN IF EXISTS accumulated_shortfall
            """))
            conn.execute(db.text("""
                ALTER TABLE match_reports 
                DROP COLUMN IF EXISTS cap_percentage
            """))
        db.session.commit()
        print("✓ Removed accumulated_shortfall and cap_percentage columns from match_reports table")
        
        # Remove columns from extraction_stats table
        with db.engine.connect() as conn:
            conn.execute(db.text("""
                ALTER TABLE extraction_stats 
                DROP COLUMN IF EXISTS accumulated_shortfall
            """))
            conn.execute(db.text("""
                ALTER TABLE extraction_stats 
                DROP COLUMN IF EXISTS cap_percentage
            """))
        db.session.commit()
        print("✓ Removed accumulated_shortfall and cap_percentage columns from extraction_stats table")
        
    except Exception as e:
        db.session.rollback()
        print(f"✗ Error removing columns: {str(e)}")
        raise

if __name__ == '__main__':
    print("Running migration: Add accumulated_shortfall and cap_percentage columns")
    print("=" * 60)
    upgrade()
    print("=" * 60)
    print("Migration completed successfully!")