"""
Migration to allow NULL values for actual_result and extraction_result columns 
in extraction_stats and match_reports tables for incomplete matches
"""
from app import db

def upgrade():
    """Allow NULL values for actual_result and extraction_result columns"""
    try:
        # Check if columns allow NULL in extraction_stats
        inspector = db.inspect(db.engine)
        extraction_stats_columns = {col['name']: col['nullable'] for col in inspector.get_columns('extraction_stats')}
        
        if 'actual_result' in extraction_stats_columns:
            if extraction_stats_columns['actual_result'] is False:
                # Alter actual_result column to allow NULL
                with db.engine.connect() as conn:
                    conn.execute(db.text("""
                        ALTER TABLE extraction_stats 
                        MODIFY COLUMN actual_result VARCHAR(50) NULL
                    """))
                db.session.commit()
                print("✓ Updated actual_result column to allow NULL in extraction_stats table")
            else:
                print("✓ actual_result column already allows NULL in extraction_stats table")
        
        if 'extraction_result' in extraction_stats_columns:
            if extraction_stats_columns['extraction_result'] is False:
                # Alter extraction_result column to allow NULL
                with db.engine.connect() as conn:
                    conn.execute(db.text("""
                        ALTER TABLE extraction_stats 
                        MODIFY COLUMN extraction_result VARCHAR(50) NULL
                    """))
                db.session.commit()
                print("✓ Updated extraction_result column to allow NULL in extraction_stats table")
            else:
                print("✓ extraction_result column already allows NULL in extraction_stats table")
        
        # Check if columns allow NULL in match_reports
        match_reports_columns = {col['name']: col['nullable'] for col in inspector.get_columns('match_reports')}
        
        if 'actual_result' in match_reports_columns:
            if match_reports_columns['actual_result'] is False:
                # Alter actual_result column to allow NULL
                with db.engine.connect() as conn:
                    conn.execute(db.text("""
                        ALTER TABLE match_reports 
                        MODIFY COLUMN actual_result VARCHAR(50) NULL
                    """))
                db.session.commit()
                print("✓ Updated actual_result column to allow NULL in match_reports table")
            else:
                print("✓ actual_result column already allows NULL in match_reports table")
        
        if 'extraction_result' in match_reports_columns:
            if match_reports_columns['extraction_result'] is False:
                # Alter extraction_result column to allow NULL
                with db.engine.connect() as conn:
                    conn.execute(db.text("""
                        ALTER TABLE match_reports 
                        MODIFY COLUMN extraction_result VARCHAR(50) NULL
                    """))
                db.session.commit()
                print("✓ Updated extraction_result column to allow NULL in match_reports table")
            else:
                print("✓ extraction_result column already allows NULL in match_reports table")
        
        print("\n✓ Migration completed successfully!")
        
    except Exception as e:
        db.session.rollback()
        print(f"✗ Error updating columns: {str(e)}")
        raise

def downgrade():
    """Revert actual_result and extraction_result columns to NOT NULL"""
    try:
        # Revert extraction_stats columns
        with db.engine.connect() as conn:
            conn.execute(db.text("""
                ALTER TABLE extraction_stats 
                MODIFY COLUMN actual_result VARCHAR(50) NOT NULL
            """))
        db.session.commit()
        print("✓ Reverted actual_result column to NOT NULL in extraction_stats table")
        
        with db.engine.connect() as conn:
            conn.execute(db.text("""
                ALTER TABLE extraction_stats 
                MODIFY COLUMN extraction_result VARCHAR(50) NOT NULL
            """))
        db.session.commit()
        print("✓ Reverted extraction_result column to NOT NULL in extraction_stats table")
        
        # Revert match_reports columns
        with db.engine.connect() as conn:
            conn.execute(db.text("""
                ALTER TABLE match_reports 
                MODIFY COLUMN actual_result VARCHAR(50) NOT NULL
            """))
        db.session.commit()
        print("✓ Reverted actual_result column to NOT NULL in match_reports table")
        
        with db.engine.connect() as conn:
            conn.execute(db.text("""
                ALTER TABLE match_reports 
                MODIFY COLUMN extraction_result VARCHAR(50) NOT NULL
            """))
        db.session.commit()
        print("✓ Reverted extraction_result column to NOT NULL in match_reports table")
        
        print("\n✓ Downgrade completed successfully!")
        
    except Exception as e:
        db.session.rollback()
        print(f"✗ Error reverting columns: {str(e)}")
        raise

if __name__ == '__main__':
    from app import create_app
    app = create_app()
    with app.app_context():
        print("Running migration: Allow NULL values for actual_result and extraction_result")
        print("=" * 70)
        upgrade()
        print("=" * 70)
