"""
Migration script to add match_id and match_number fields to bets and extraction_stats tables
"""

def upgrade():
    """Add match_id and match_number fields to bets table, match_number to extraction_stats table"""
    from app import create_app, db
    from app.models import Bet, ExtractionStats
    
    app = create_app()
    
    with app.app_context():
        # Check if match_id column exists in bets table
        inspector = db.inspect(db.engine)
        bets_columns = [col['name'] for col in inspector.get_columns('bets')]
        
        if 'match_id' not in bets_columns:
            print("Adding match_id column to bets table...")
            db.engine.execute(db.DDL(
                "ALTER TABLE bets ADD COLUMN match_id INTEGER NOT NULL DEFAULT 0"
            ))
            print("match_id column added to bets table")
        else:
            print("match_id column already exists in bets table")
        
        if 'match_number' not in bets_columns:
            print("Adding match_number column to bets table...")
            db.engine.execute(db.DDL(
                "ALTER TABLE bets ADD COLUMN match_number INTEGER NOT NULL DEFAULT 0"
            ))
            print("match_number column added to bets table")
        else:
            print("match_number column already exists in bets table")
        
        # Check if match_number column exists in extraction_stats table
        extraction_stats_columns = [col['name'] for col in inspector.get_columns('extraction_stats')]
        
        if 'match_number' not in extraction_stats_columns:
            print("Adding match_number column to extraction_stats table...")
            db.engine.execute(db.DDL(
                "ALTER TABLE extraction_stats ADD COLUMN match_number INTEGER NOT NULL DEFAULT 0"
            ))
            print("match_number column added to extraction_stats table")
        else:
            print("match_number column already exists in extraction_stats table")
        
        # Create indexes for better query performance
        print("Creating indexes...")
        
        # Index on bets.match_id
        try:
            db.engine.execute(db.DDL(
                "CREATE INDEX IF NOT EXISTS idx_bets_match_id ON bets(match_id)"
            ))
            print("Index idx_bets_match_id created")
        except Exception as e:
            print(f"Index idx_bets_match_id already exists or error: {e}")
        
        print("\nMigration completed successfully!")

def downgrade():
    """Remove match_id and match_number fields from bets and extraction_stats tables"""
    from app import create_app, db
    
    app = create_app()
    
    with app.app_context():
        print("Removing match_id and match_number columns from bets table...")
        db.engine.execute(db.DDL("ALTER TABLE bets DROP COLUMN match_id"))
        db.engine.execute(db.DDL("ALTER TABLE bets DROP COLUMN match_number"))
        
        print("Removing match_number column from extraction_stats table...")
        db.engine.execute(db.DDL("ALTER TABLE extraction_stats DROP COLUMN match_number"))
        
        print("\nDowngrade completed successfully!")

if __name__ == '__main__':
    import sys
    
    if len(sys.argv) > 1 and sys.argv[1] == 'downgrade':
        downgrade()
    else:
        upgrade()