from PyInstaller.utils.hooks import collect_all

# Collect all numpy modules and data files
datas, binaries, hiddenimports = collect_all('numpy')

# Add specific numpy submodules that are commonly needed
hiddenimports += [
    'numpy.core._dtype_ctypes',
    'numpy.random.common',
    'numpy.random.bounded_integers',
    'numpy.random.entropy',
    'numpy.random.mtrand',
    'numpy.random._sfc64',
    'numpy.random._philox',
    'numpy.random._pcg64',
    'numpy.random._mt19937',
    'numpy.random.bit_generator',
    'numpy.random._generator',
    'numpy.fft.helper',
    'numpy.lib.stride_tricks',
    'numpy.lib.recfunctions',
    'numpy.lib._iotools',
    'numpy.lib.format',
    'numpy.lib._datasource',
    'numpy.lib._version',
    'numpy.lib._util',
    'numpy.lib._testutils',
    'numpy.lib._ufunclike',
    'numpy.lib._type_check',
    'numpy.lib._string_helpers',
    'numpy.lib._scipy',
    'numpy.lib._polynomial',
    'numpy.lib._nanfunctions',
    'numpy.lib._histograms',
    'numpy.lib._function_base',
    'numpy.lib._financial',
    'numpy.lib._deprecation',
    'numpy.lib._arraysetops',
    'numpy.lib._arraypad',
    'numpy.lib._arrayterator',
    'numpy.lib._array_utils',
    'numpy.lib._array_config',
    'numpy.lib._array_function',
    'numpy.lib._array_coercion',
    'numpy.lib._array_convert',
    'numpy.lib._array_assign',
    'numpy.lib._array_assign_scalar',
    'numpy.lib._array_assign_array',
    'numpy.lib._array_assign_mask',
    'numpy.lib._array_assign_broadcast',
    'numpy.lib._array_assign_ufunc',
    'numpy.lib._array_assign_ufunc_scalar',
    'numpy.lib._array_assign_ufunc_array',
    'numpy.lib._array_assign_ufunc_mask',
    'numpy.lib._array_assign_ufunc_broadcast',
]

# Add numpy ctypes files that are often missing
import numpy as np
import os

# Get numpy directory
numpy_dir = os.path.dirname(np.__file__)

# Add ctypes files
ctypes_dir = os.path.join(numpy_dir, 'core', 'include', 'numpy')
if os.path.exists(ctypes_dir):
    datas.append((ctypes_dir, 'numpy/core/include/numpy'))

# Add lib files
lib_dir = os.path.join(numpy_dir, 'core', 'lib')
if os.path.exists(lib_dir):
    datas.append((lib_dir, 'numpy/core/lib'))

# Add random files
random_dir = os.path.join(numpy_dir, 'random')
if os.path.exists(random_dir):
    datas.append((random_dir, 'numpy/random'))