from flask_wtf import FlaskForm
from flask_wtf.file import FileField, FileRequired, FileAllowed
from wtforms import SubmitField, TextAreaField
from wtforms.validators import Optional

class FixtureUploadForm(FlaskForm):
    """Form for uploading fixture files (CSV/XLSX)"""
    fixture_file = FileField('Fixture File', validators=[
        FileRequired(message='Please select a fixture file'),
        FileAllowed(['csv', 'xlsx', 'xls'], 
                   message='Only CSV and Excel files are allowed')
    ])
    description = TextAreaField('Description (Optional)', validators=[Optional()])
    submit = SubmitField('Upload Fixture')

class ZipUploadForm(FlaskForm):
    """Form for uploading ZIP files for matches"""
    zip_file = FileField('ZIP File', validators=[
        FileRequired(message='Please select a ZIP file'),
        FileAllowed(['zip'], message='Only ZIP files are allowed')
    ])
    description = TextAreaField('Description (Optional)', validators=[Optional()])
    submit = SubmitField('Upload ZIP')