"""
Migration to add cap_compensation_balance field to report_syncs table
"""
from datetime import datetime
from app import db
from app.models import ReportSync

def upgrade():
    """Add cap_compensation_balance column to report_syncs table"""
    try:
        # Check if column already exists
        inspector = db.inspect(db.engine)
        columns = [col['name'] for col in inspector.get_columns('report_syncs')]
        
        if 'cap_compensation_balance' not in columns:
            # Add the column
            with db.engine.connect() as conn:
                conn.execute(db.text("""
                    ALTER TABLE report_syncs 
                    ADD COLUMN cap_compensation_balance NUMERIC(15, 2) DEFAULT 0.00
                """))
            db.session.commit()
            print("Successfully added cap_compensation_balance column to report_syncs table")
        else:
            print("cap_compensation_balance column already exists in report_syncs table")
            
    except Exception as e:
        db.session.rollback()
        print(f"Error adding cap_compensation_balance column: {str(e)}")
        raise

def downgrade():
    """Remove cap_compensation_balance column from report_syncs table"""
    try:
        with db.engine.connect() as conn:
            conn.execute(db.text("""
                ALTER TABLE report_syncs 
                DROP COLUMN IF EXISTS cap_compensation_balance
            """))
        db.session.commit()
        print("Successfully removed cap_compensation_balance column from report_syncs table")
    except Exception as e:
        db.session.rollback()
        print(f"Error removing cap_compensation_balance column: {str(e)}")
        raise

if __name__ == '__main__':
    print("Running migration: add_cap_compensation_balance")
    upgrade()