# MbetterClient

A cross-platform multimedia client application with video playback, web dashboard, and REST API integration.

## Features

- **PyQt Video Player**: Fullscreen video playback with customizable overlay templates
- **Web Dashboard**: Authentication, user management, and configuration interface
- **REST API Client**: Configurable external API integration with automatic retry
- **Multi-threaded Architecture**: Four threads with Queue-based message passing
- **Offline Capability**: Works seamlessly without internet connectivity
- **Cross-Platform**: Supports Windows, Linux, and macOS
- **Single Executable**: Built with PyInstaller for easy deployment

## Architecture

The application consists of four main threads:

1. **PyQt Thread**: Video player with overlay rendering
2. **Web Dashboard Thread**: Flask-based web interface
3. **REST API Client Thread**: External API communication
4. **Main Loop Thread**: Inter-thread message coordination

## Quick Start

### Installation

```bash
# Clone the repository
git clone https://git.nexlab.net/mbetter/mbetterc.git
cd mbetterc

# Create virtual environment
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate

# Install dependencies
pip install -r requirements.txt
```

### Running the Application

```bash
# Run in fullscreen mode (default)
python main.py

# Run in windowed mode
python main.py --no-fullscreen

# Show help
python main.py --help
```

### Building Executable

```bash
# Build for current platform
python build.py

# The executable will be in dist/ directory
```

## Configuration

Configuration is stored in SQLite database with automatic versioning. Access the web dashboard at `http://localhost:5001` (default) to configure:

- Video overlay templates
- REST API endpoints and tokens
- User authentication
- System settings

## Development

### Project Structure

```
mbetterc/
├── main.py                 # Application entry point
├── requirements.txt        # Python dependencies
├── build.py               # PyInstaller build script
├── mbetterclient/         # Main application package
│   ├── __init__.py
│   ├── config/            # Configuration management
│   ├── database/          # SQLite database and models
│   ├── qt_player/         # PyQt video player
│   ├── web_dashboard/     # Flask web interface
│   ├── api_client/        # REST API client
│   ├── core/              # Main loop and message handling
│   └── utils/             # Utility functions
├── assets/                # Static assets (images, templates)
├── templates/             # Video overlay templates
├── tests/                 # Unit tests
└── docs/                  # Documentation
```

### Message System

Threads communicate via Python Queues with structured messages:

```python
{
    "type": "VIDEO_PLAY",
    "data": {
        "file_path": "/path/to/video.mp4",
        "template": "news_template",
        "overlay_data": {...}
    },
    "timestamp": 1234567890.123,
    "sender": "web_dashboard"
}
```

## API Documentation

### Web Dashboard API

- `POST /auth/login` - User authentication
- `GET /api/tokens` - List JWT tokens
- `POST /api/tokens` - Create new token
- `DELETE /api/tokens/{id}` - Delete token
- `GET /api/config` - Get configuration
- `PUT /api/config` - Update configuration

### Message Types

#### Video Control
- `VIDEO_PLAY` - Start video playback
- `VIDEO_PAUSE` - Pause video
- `VIDEO_STOP` - Stop video
- `VIDEO_PROGRESS` - Progress update from player

#### API Client
- `API_REQUEST` - Make external API request
- `API_RESPONSE` - Response from external API
- `API_ERROR` - API request error

#### Configuration
- `CONFIG_UPDATE` - Configuration changed
- `TEMPLATE_CHANGE` - Video template changed

## License

Copyright (c) 2025 MBetter Project. All rights reserved.

## Support

For support and documentation, visit the project repository.