# Changelog

All notable changes to MbetterClient will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.0.0] - 2025-01-19

### Added
- Initial release of MbetterClient
- PyQt5 video player with hardware acceleration support
- Dynamic overlay system with three built-in templates:
  - News template with scrolling ticker
  - Sports template with live scores
  - Simple template for basic text overlays
- Flask-based web dashboard with modern UI
- JWT authentication with role-based access control
- User management system with admin and regular user roles
- API token management for secure API access
- REST API client with configurable endpoints
- Automatic retry logic and error handling for API requests
- Built-in response handlers for news and sports APIs
- SQLite database with automatic schema migrations
- Multi-threaded architecture with Queue-based message passing
- Cross-platform executable generation with PyInstaller
- Offline-first design with local asset fallbacks
- Comprehensive configuration management
- Real-time system status monitoring
- Application logging with rotation and filtering
- Command-line interface with multiple options
- Web-based configuration interface
- Template-based video overlays with real-time data
- Fullscreen video playback support
- Video control via web dashboard and keyboard shortcuts

### Security
- Password hashing with salt
- Secure session management
- CSRF protection for web forms
- JWT token expiration and refresh
- API rate limiting and validation
- Secure configuration file handling

### Performance
- Hardware-accelerated video playback
- Efficient message bus with priority handling
- Lazy loading of video codecs
- Optimized database queries with connection pooling
- Memory-efficient overlay rendering
- Compressed static assets for web dashboard

### Documentation
- Complete user documentation
- API reference with examples
- Development guide with contribution guidelines
- Troubleshooting guide
- Build and deployment instructions
- Code examples and tutorials

### Supported Platforms
- Windows 10 and later
- macOS 10.14 and later  
- Linux (Ubuntu 18.04+, CentOS 7+, Debian 10+)

### Dependencies
- Python 3.8+
- PyQt5 5.15.10
- Flask 3.0.3
- SQLAlchemy 2.0.25
- Requests 2.31.0
- PyInstaller 6.3.0
- And other dependencies listed in requirements.txt

### Known Issues
- Large video files may cause memory issues on systems with < 1GB RAM
- Some video codecs require additional system libraries on Linux
- Windows Defender may flag executables built with PyInstaller

### Migration Notes
- This is the initial release, no migration required
- Default admin credentials must be changed on first login
- Configuration files are created automatically on first run

## [Future Releases]

### Planned Features
- Plugin system for custom extensions
- Advanced video effects and transitions
- WebRTC streaming support
- Mobile device remote control
- Multi-monitor support with independent overlays
- Cloud configuration synchronization
- Advanced analytics and reporting
- Integration with popular streaming platforms
- Real-time collaboration features
- Advanced template editor with drag-and-drop interface

### Potential Breaking Changes
- Configuration file format may change in v2.0
- Message bus API may be redesigned for better performance
- Database schema updates may require manual migration
- Web dashboard API may be versioned for backward compatibility

---

## Version History

| Version | Release Date | Notes |
|---------|-------------|--------|
| 1.0.0   | 2025-01-19  | Initial release |

## Support Policy

- **Current Version (1.x)**: Full support with bug fixes and security updates
- **Previous Versions**: Security updates only for 6 months after new major release
- **LTS Versions**: Will be designated for enterprise users starting with v2.0

## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md) for guidelines on how to contribute to this project.

## License

This project is licensed under the MIT License - see [LICENSE](LICENSE) for details.