#!/bin/bash
# Remote debugging script for overlay/GPU issues on nvidia-tesla-470 system

echo "=== REMOTE DEBUGGING SCRIPT FOR OVERLAY/GPU ISSUES ==="
echo "System: $(uname -a)"
echo "Date: $(date)"
echo ""

echo "=== NVIDIA GPU STATUS ==="
nvidia-smi
echo ""

echo "=== GPU PROCESSES ==="
nvidia-smi pmon
echo ""

echo "=== OPENGL STATUS ==="
glxinfo | head -20
echo ""

echo "=== DIRECT RENDERING STATUS ==="
glxinfo | grep -i direct
echo ""

echo "=== VULKAN STATUS ==="
if command -v vulkaninfo &> /dev/null; then
    vulkaninfo --summary
else
    echo "vulkaninfo not available"
fi
echo ""

echo "=== ENVIRONMENT VARIABLES ==="
echo "DISPLAY: $DISPLAY"
echo "XDG_SESSION_TYPE: $XDG_SESSION_TYPE"
echo "QT_QPA_PLATFORM: $QT_QPA_PLATFORM"
echo "LIBGL_ALWAYS_SOFTWARE: $LIBGL_ALWAYS_SOFTWARE"
echo "MESA_GL_VERSION_OVERRIDE: $MESA_GL_VERSION_OVERRIDE"
echo ""

echo "=== RUNNING MBETTERCLIENT WITH DEBUG LOGGING ==="
echo "Please run the following command on your system:"
echo "./MbetterClient --debug --debug-overlay --debug-player --no-fullscreen"
echo ""
echo "This will:"
echo "- Enable debug logging"
echo "- Enable overlay debug mode"
echo "- Enable player debug mode"
echo "- Run in windowed mode for easier debugging"
echo ""
echo "Then check the logs for:"
echo "1. OVERLAY VISIBILITY CHECK messages"
echo "2. QT WEBENGINE GPU ACCELERATION CHECK messages"
echo "3. TEMPLATE LOADING messages"
echo "4. GPU process monitoring messages"
echo ""
echo "If overlay templates are not shown, look for:"
echo "- 'NO GPU PROCESSES FOUND' warnings"
echo "- Mesa software rendering detection"
echo "- Template loading failures"
echo "- Overlay window visibility issues"