#!/bin/bash
# Clean script for MbetterClient build artifacts

echo "🧹 MbetterClient Clean Script"
echo "============================"

# Clean build directories
echo "🗂️  Removing build directories..."
if [ -d "build" ]; then
    rm -rf build
    echo "   ✅ Removed: build/"
else
    echo "   ℹ️  Build directory not found"
fi

if [ -d "dist" ]; then
    echo "   📁 Preserving dist/ directory (not cleaning)"
    echo "   📋 Files in dist/:"
    ls -la dist/
else
    echo "   ℹ️  Dist directory not found"
fi

# Clean generated spec files
echo "📄 Removing generated spec files..."
if [ -f "MbetterClient.spec" ]; then
    rm -f MbetterClient.spec
    echo "   ✅ Removed: MbetterClient.spec"
else
    echo "   ℹ️  MbetterClient.spec not found"
fi

if [ -f "mbetter_discovery.spec" ]; then
    rm -f mbetter_discovery.spec
    echo "   ✅ Removed: mbetter_discovery.spec"
else
    echo "   ℹ️  mbetter_discovery.spec not found"
fi

# Clean packages directory (automatic)
echo "📦 Removing packages directory..."
if [ -d "packages" ]; then
    rm -rf packages
    echo "   ✅ Removed: packages/"
else
    echo "   ℹ️  Packages directory not found"
fi

# Clean __pycache__ directories
echo "🐍 Removing Python cache files..."
find . -type d -name "__pycache__" -exec rm -rf {} + 2>/dev/null || true
find . -name "*.pyc" -delete 2>/dev/null || true
find . -name "*.pyo" -delete 2>/dev/null || true

echo ""
echo "✅ Clean completed!"
echo ""
echo "To rebuild, run: ./build.sh"