#!/bin/bash
# Clean up files created by build_pyqt6.sh

echo "🧹 Cleaning up PyQt6 build artifacts"
echo "===================================="

# Remove QEMU image
IMG="/srv/sbuild/qemu/sid-amd64.img"
if [ -f "$IMG" ]; then
    echo "🗑️  Removing QEMU image: $IMG"
    sudo rm -f "$IMG"
else
    echo "ℹ️  QEMU image not found"
fi

# Remove QEMU directory if empty
QEMU_DIR="/srv/sbuild/qemu"
if [ -d "$QEMU_DIR" ] && [ -z "$(ls -A $QEMU_DIR)" ]; then
    echo "🗑️  Removing empty QEMU directory: $QEMU_DIR"
    sudo rmdir "$QEMU_DIR"
fi

# Remove extracted PyQt6 directory
if [ -d "pyqt6_built" ]; then
    echo "🗑️  Removing extracted PyQt6 directory: pyqt6_built"
    rm -rf pyqt6_built
else
    echo "ℹ️  pyqt6_built directory not found"
fi

# Remove built .deb files
if ls python3-pyqt6_*.deb 1> /dev/null 2>&1; then
    echo "🗑️  Removing built .deb files: python3-pyqt6_*.deb"
    rm -f python3-pyqt6_*.deb
else
    echo "ℹ️  No python3-pyqt6 .deb files found"
fi

echo "✅ Cleanup completed!"