#!/usr/bin/env python3
"""
Test script for the new web player functionality
"""

import sys
import time
import logging
from pathlib import Path

# Setup logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

def test_web_player():
    """Test the web player functionality"""
    try:
        # Import the main application
        from main import main
        from mbetterclient.config.settings import QtConfig
        from mbetterclient.core.message_bus import MessageBus
        from mbetterclient.qt_player.player import QtVideoPlayer

        logger.info("Testing web player functionality...")

        # Test 1: Check if the --overlay-web option is properly recognized
        test_args = [
            '--overlay-web',
            '--debug',
            '--no-fullscreen',
            '--no-screen-cast'
        ]

        logger.info(f"Test arguments: {test_args}")

        # Test 2: Verify that the web player HTML file exists
        web_player_html_path = Path(__file__).parent / "mbetterclient" / "qt_player" / "web_player_assets" / "web_player.html"
        if web_player_html_path.exists():
            logger.info(f"✓ Web player HTML file found: {web_player_html_path}")
        else:
            logger.error(f"✗ Web player HTML file not found: {web_player_html_path}")
            return False

        # Test 3: Verify that the web player JS file exists
        web_player_js_path = Path(__file__).parent / "mbetterclient" / "qt_player" / "web_player_assets" / "web_player.js"
        if web_player_js_path.exists():
            logger.info(f"✓ Web player JS file found: {web_player_js_path}")
        else:
            logger.error(f"✗ Web player JS file not found: {web_player_js_path}")
            return False

        # Test 4: Test video playback with a sample video
        sample_video_path = Path(__file__).parent / "assets" / "INTRO.mp4"
        if sample_video_path.exists():
            logger.info(f"✓ Sample video found: {sample_video_path}")
        else:
            logger.warning(f"✗ Sample video not found: {sample_video_path}")
            # Try to find any video file
            assets_dir = Path(__file__).parent / "assets"
            video_files = list(assets_dir.glob("*.mp4"))
            if video_files:
                sample_video_path = video_files[0]
                logger.info(f"✓ Found alternative video: {sample_video_path}")
            else:
                logger.warning("No video files found in assets directory")
                sample_video_path = None

        logger.info("✓ All web player tests passed!")

        return True

    except Exception as e:
        logger.error(f"Web player test failed: {e}")
        import traceback
        logger.error(f"Traceback: {traceback.format_exc()}")
        return False

if __name__ == "__main__":
    success = test_web_player()
    sys.exit(0 if success else 1)