# -*- mode: python ; coding: utf-8 -*-
"""
PyInstaller spec file for MBetter Discovery Application - Linux
"""

block_cipher = None

# Qt platform plugins and X11 libraries
qt_platform_plugins = [
    ('/usr/lib/x86_64-linux-gnu/qt6/plugins/platforms/libqxcb.so', 'platforms/'),
    ('/usr/lib/x86_64-linux-gnu/qt6/plugins/platforms/libqwayland-egl.so', 'platforms/'),
    ('/usr/lib/x86_64-linux-gnu/qt6/plugins/platforms/libqwayland-generic.so', 'platforms/'),
    ('/usr/lib/x86_64-linux-gnu/qt6/plugins/platforms/libqoffscreen.so', 'platforms/'),
]

# Minimal X11 libraries - only include essential ones to avoid version conflicts
# Most X11 libraries should be provided by the system to prevent segfaults
x11_libraries = [
    ('/lib/x86_64-linux-gnu/libxcb.so.1', '.'),  # Core xcb library
    ('/lib/x86_64-linux-gnu/libX11.so.6', '.'),  # Core X11 library
]

a = Analysis(
    ['mbetter_discovery.py'],
    pathex=[],
    binaries=qt_platform_plugins + x11_libraries,
    datas=[],
    hiddenimports=[
        'PyQt6.QtCore',
        'PyQt6.QtGui',
        'PyQt6.QtWidgets',
        'PyQt6.QtDBus',
        'netifaces',
        'ffmpeg',
        'ffmpeg.errors',
        'ffmpeg.ffmpeg',
        'ffmpeg.file',
        'ffmpeg.options',
        'ffmpeg.progress',
        'ffmpeg.protocol',
        'ffmpeg.statistics',
        'ffmpeg.types',
        'ffmpeg.utils',
        'dbus',
        'dbus.mainloop',
        'dbus.mainloop.glib',
    ],
    hookspath=['.'],
    hooksconfig={},
    runtime_hooks=[],
    excludes=[
        'tkinter',
        'matplotlib',
        'numpy',
        'PIL',
        'cv2',
    ],
    win_no_prefer_redirects=False,
    win_private_assemblies=False,
    cipher=block_cipher,
    noarchive=False,
)

pyz = PYZ(a.pure, a.zipped_data, cipher=block_cipher)

exe = EXE(
    pyz,
    a.scripts,
    a.binaries,
    a.zipfiles,
    a.datas,
    [],
    name='MBetterDiscovery',
    debug=False,
    bootloader_ignore_signals=False,
    strip=False,
    upx=True,
    upx_exclude=[],
    runtime_tmpdir=None,
    console=False,  # Set to True for debugging
    disable_windowed_traceback=False,
    argv_emulation=False,
    target_arch=None,
    codesign_identity=None,
    entitlements_file=None,
)