"""
Database management for MbetterClient with SQLite and versioning support
"""

from .manager import DatabaseManager
from .models import (
    BaseModel,
    DatabaseVersion,
    UserModel,
    ConfigurationModel,
    ApiTokenModel,
    LogEntryModel,
    TemplateModel,
    AvailableBetModel,
    ResultOptionModel
)
from .migrations import DatabaseMigration, run_migrations

__all__ = [
    'DatabaseManager',
    'BaseModel',
    'DatabaseVersion',
    'UserModel',
    'ConfigurationModel',
    'ApiTokenModel',
    'LogEntryModel',
    'TemplateModel',
    'AvailableBetModel',
    'ResultOptionModel',
    'DatabaseMigration',
    'run_migrations'
]