import re

with open('mbetterclient/web_dashboard/templates/dashboard/fixtures.html', 'r') as f:
    content = f.read()

# Check for basic HTML structure
if '<!DOCTYPE' in content or content.strip().startswith('<'):
    print('HTML template appears to have valid structure')
else:
    print('HTML template may have issues')

# Check for JavaScript syntax errors
js_matches = re.findall(r'<script[^>]*>(.*?)</script>', content, re.DOTALL)
if js_matches:
    print('Found ' + str(len(js_matches)) + ' script tags')
    for i, js in enumerate(js_matches):
        try:
            compile(js, 'script_' + str(i), 'exec')
            print('Script ' + str(i+1) + ': OK')
        except SyntaxError as e:
            print('Script ' + str(i+1) + ': Syntax error - ' + str(e))
else:
    print('No script tags found')