#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Test script for --dev-message functionality
"""

import sys
import os
from pathlib import Path

# Add the project root to Python path
project_root = Path(__file__).parent
sys.path.insert(0, str(project_root))

from mbetterclient.core.message_bus import MessageBus, Message, MessageType
from mbetterclient.config.settings import AppSettings

def test_dev_message_flag():
    """Test the --dev-message flag functionality"""
    print("Testing --dev-message flag functionality")
    print("=" * 50)

    # Test 1: Normal mode (dev_message=False)
    print("\nTest 1: Normal mode (dev_message=False)")
    message_bus_normal = MessageBus(dev_message=False)

    # Create a test message
    test_message = Message(
        type=MessageType.START_GAME,
        sender="test_component",
        data={"fixture_id": "test_123"}
    )

    print("Publishing message in normal mode...")
    message_bus_normal.publish(test_message)
    print("Normal mode test completed")

    # Test 2: Dev message mode (dev_message=True)
    print("\nTest 2: Dev message mode (dev_message=True)")
    message_bus_dev = MessageBus(dev_message=True)

    print("Publishing message in dev message mode...")
    message_bus_dev.publish(test_message)
    print("Dev message mode test completed")

    # Test 3: Settings integration
    print("\nTest 3: Settings integration")
    settings = AppSettings()
    settings.dev_message = True

    message_bus_from_settings = MessageBus(dev_message=settings.dev_message)
    print(f"MessageBus created with dev_message={message_bus_from_settings.dev_message}")
    print("Settings integration test completed")

    print("\nAll tests completed successfully!")
    print("\nUsage:")
    print("   python main.py --dev-message    # Enable dev message mode")
    print("   python main.py                  # Normal mode (default)")

if __name__ == "__main__":
    test_dev_message_flag()