#!/usr/bin/env python3
"""
Test script for headless RTSP/HLS streaming
"""

import sys
import time
import os
from pathlib import Path

# Add the project root to Python path
project_root = Path(__file__).parent
sys.path.insert(0, str(project_root))

from mbetterclient.core.message_bus import MessageBus, Message, MessageType, MessageBuilder

def test_headless_streaming():
    """Test headless streaming by sending video play messages"""

    # Create message bus
    message_bus = MessageBus()

    # Register test component
    message_bus.register_component("test")

    print("Starting headless streaming test...")

    # Send a video play message for the INTRO video
    intro_path = project_root / "assets" / "INTRO.mp4"

    if not intro_path.exists():
        print(f"INTRO.mp4 not found at {intro_path}")
        return

    print(f"Playing video: {intro_path}")

    # Create video play message
    video_play_message = MessageBuilder.video_play(
        sender="test",
        file_path=str(intro_path),
        overlay_data={"title": "Test Stream", "message": "Headless streaming test"}
    )

    # Publish the message
    message_bus.publish(video_play_message, broadcast=True)

    print("Video play message sent. Streaming should start...")

    # Wait a bit
    time.sleep(5)

    print("Test completed. Check if streaming is working.")

if __name__ == "__main__":
    test_headless_streaming()