# Changelog

All notable changes to this project will be documented in this file.

## [1.1.0] - 2025-08-19

### Added
- Enhanced token creation workflow with professional modal dialogs
- Comprehensive troubleshooting section in README
- Default admin user creation on first run
- Permanent token deletion functionality
- Section-based configuration updates
- Database operation stability improvements

### Fixed
- **Critical**: Application now exits gracefully with single Ctrl+C press
- **Critical**: API tokens properly display after creation in web interface
- **Critical**: User creation now saves properly and displays immediately
- **Critical**: Configuration updates through web dashboard now work correctly
- SQLAlchemy session binding issues causing data access errors
- Token revocation now permanently deletes tokens from database
- Frontend JavaScript token management and display
- Database operations extract data before session closure
- Signal handler optimization with reduced timeouts
- Web dashboard routing and static file loading issues
- ConfigManager missing update_section method

### Changed
- Reduced application shutdown timeouts for faster exit (10s→3s, 5s→2s)
- Updated README with comprehensive troubleshooting guide
- Enhanced API documentation with all endpoints
- Improved error handling across all components

### Technical Details
- Fixed database session binding by extracting data to dictionaries
- Added proper signal handling flow: signal → shutdown event → cleanup → exit
- Enhanced frontend with Bootstrap modal dialogs for token display
- Implemented section-based configuration management
- Added comprehensive session lifecycle management

## [1.0.0] - 2025-08-15

### Added
- Initial release of MbetterClient
- PyQt video player with overlay support
- Flask web dashboard with authentication
- REST API client with configurable endpoints
- Multi-threaded architecture with message bus
- SQLite database with versioning system
- PyInstaller build configuration
- Cross-platform support (Windows, Linux, macOS)
- JWT and long-lived API token management
- User management system
- Configuration management interface
- Video upload and playback testing

### Features
- Fullscreen and windowed video playback modes
- Customizable video overlay templates
- Web-based administration interface
- API token creation and management
- User authentication and authorization
- Database migrations system
- Message-based inter-thread communication
- Comprehensive logging system
- Configuration persistence