# MBetter Client Discovery Application

A Qt6-based LAN discovery tool that automatically detects MBetterClient servers on the local network and opens the dashboard in a web browser.

## Features

- **Automatic Discovery**: Listens for UDP broadcasts from MBetterClient servers on the local network
- **Cross-Platform**: Compatible with Linux and Windows
- **System Tray Support**: Runs minimized in the system tray
- **Auto-Open Browser**: Automatically opens discovered servers in the default web browser
- **Manual Connection**: Connect to servers manually by entering their URL
- **SSL Support Detection**: Identifies servers running with SSL/HTTPS enabled
- **Real-time Updates**: Shows discovered servers in real-time with timestamps

## Installation & Setup

### Quick Setup

1. Run the setup script to install dependencies:
```bash
python3 setup_discovery.py  # Linux/Mac
python setup_discovery.py   # Windows
```

2. Run the discovery application:
```bash
./run_discovery.sh          # Linux/Mac
run_discovery.bat           # Windows
```

### Manual Installation

1. Install required Python packages:
```bash
pip install PyQt6 netifaces
```

2. Run the application:
```bash
python3 mbetter_discovery.py
```

### Creating Standalone Executable

The setup script can create a standalone executable:
```bash
python3 setup_discovery.py
# When prompted, choose 'y' to create executable
```

The executable will be created in the `dist/` directory.

## How It Works

### UDP Broadcast Protocol

The MBetterClient main application broadcasts UDP packets every 30 seconds on port `45123` with the following JSON structure:

```json
{
    "service": "MBetterClient",
    "host": "192.168.1.100",
    "port": 5001,
    "ssl": false,
    "url": "http://192.168.1.100:5001",
    "timestamp": 1693910123.456
}
```

### Discovery Process

1. The discovery app listens on UDP port `45123` (configurable)
2. When a broadcast is received, it validates the JSON structure
3. If valid, the server is added to the discovered servers list
4. If auto-open is enabled, the browser opens the server's dashboard URL
5. The app shows a system tray notification about the discovery

## Usage

### Main Window

- **Settings Section**: Configure auto-open browser and listen port
- **Discovered Servers**: Shows all found servers with their URLs and discovery time
- **Manual Connection**: Enter a URL manually to connect to a server
- **Status & Log**: Real-time status and activity log

### System Tray

- Right-click the tray icon to access the menu
- Double-click to show/hide the main window
- The application continues running in the background when the window is closed

### Keyboard Shortcuts

- Double-click a server in the list to open it in the browser
- The application minimizes to tray when closed (if system tray is available)

## Configuration

### Settings

- **Auto-open Browser**: Automatically open discovered servers in the default browser
- **Listen Port**: UDP port to listen for broadcasts (default: 45123)

### Manual Connection

If you know the IP address of a MBetterClient server, you can connect manually:
1. Enter the URL in the "Manual URL" field (e.g., `http://192.168.1.100:5001`)
2. Click "Connect" to open it in the browser

## Network Requirements

### Firewall Configuration

Ensure the following ports are open:

- **UDP 45123**: For receiving broadcasts (incoming)
- **TCP 80/443**: For HTTP/HTTPS web access (outgoing)

### Network Discovery

The application works on:
- Local Area Networks (LAN)
- Wi-Fi networks
- Wired Ethernet networks
- VPN networks (if UDP broadcasts are allowed)

## Troubleshooting

### Common Issues

**No servers discovered:**
- Check that MBetterClient is running on the network
- Verify firewall settings allow UDP traffic on port 45123
- Ensure you're on the same network segment
- Try changing the listen port in settings

**Application won't start:**
- Ensure Python 3.7+ is installed
- Install required dependencies: `pip install PyQt6 netifaces`
- Check the log output for specific error messages

**Browser doesn't open automatically:**
- Check the "Auto-open browser" setting is enabled
- Manually click on discovered servers in the list
- Use the manual connection feature

**System tray not working:**
- Some Linux environments may not support system tray
- The application will still work without tray functionality
- Use the "Minimize to Tray" button to test tray support

### Debug Mode

Run with Python directly to see detailed logging:
```bash
python3 mbetter_discovery.py
```

Check the log output in the application window for troubleshooting information.

## Technical Details

### Dependencies

- **PyQt6**: GUI framework
- **netifaces**: Network interface detection (optional, improves broadcast detection)
- **Standard Python libraries**: socket, json, threading, webbrowser

### Protocol Details

- **Transport**: UDP broadcast
- **Port**: 45123 (configurable)
- **Format**: JSON
- **Frequency**: Every 30 seconds from MBetterClient servers
- **Scope**: Local network broadcast domain

### Security Notes

- UDP broadcasts are unencrypted and visible to all network users
- No authentication is required for discovery
- The discovery process only reads broadcast messages, it doesn't send any data
- Browser connections use the server's configured protocol (HTTP/HTTPS)

## Building from Source

### Development Setup

1. Clone or copy the discovery files:
   - `mbetter_discovery.py` - Main application
   - `setup_discovery.py` - Setup script
   - `DISCOVERY_README.md` - This documentation

2. Install development dependencies:
```bash
pip install PyQt6 netifaces pyinstaller
```

3. Run directly:
```bash
python3 mbetter_discovery.py
```

### Creating Distribution

Use PyInstaller to create standalone executables:

```bash
# Single file executable
pyinstaller --onefile --windowed --name MBetterDiscovery mbetter_discovery.py

# Directory distribution (includes all dependencies)
pyinstaller --windowed --name MBetterDiscovery mbetter_discovery.py
```

## License

This discovery application is part of the MBetterClient project and follows the same licensing terms.