#!/bin/bash
# Build script for Unix systems (Linux/macOS)

echo "🚀 MbetterClient Build Script"
echo "============================="

# Check if Python 3 is available
if ! command -v python3 &> /dev/null; then
    echo "❌ Python 3 is required but not installed."
    exit 1
fi

# Check if virtual environment exists
if [ ! -d "venv" ]; then
    echo "⚠️  Virtual environment not found. Creating one..."
    python3 -m venv venv
fi

# Activate virtual environment
echo "🔧 Activating virtual environment..."
source venv/bin/activate

# Install/upgrade dependencies
echo "📦 Installing dependencies..."
if [ -n "$VIRTUAL_ENV" ]; then
    echo "   📦 Using virtual environment: $VIRTUAL_ENV"
    pip install --upgrade pip
    pip install -r requirements.txt

    # Verify critical package installations
    echo "   🔍 Verifying critical package installations..."

    # Check ffmpeg-python
    python3 -c "import ffmpeg; print('✅ ffmpeg-python installed successfully')" || {
        echo "   ❌ ffmpeg-python import failed, installing..."
        pip install ffmpeg-python>=0.2.0
    }

    # Check dbus (optional, for Qt D-Bus support)
    python3 -c "import dbus; print('✅ dbus installed successfully')" || {
        echo "   ⚠️  dbus not available, trying to install..."
        pip install dbus-python || {
            echo "   ❌ Could not install dbus-python, Qt D-Bus support will be limited"
        }
    }
else
    echo "   ⚠️  Not in virtual environment, using --break-system-packages"
    pip install --upgrade pip --break-system-packages
    pip install -r requirements.txt --break-system-packages
fi

# Run the build script
echo "🔨 Starting build process..."
python3 build.py

# Removed Qt platform plugins and qt.conf copying for self-contained binary
echo "📦 Building self-contained binary - no external Qt files needed"

echo "✅ Build script completed!"