#!/usr/bin/env python3
"""
Script to check database schema and table structure
"""

import sqlite3
from pathlib import Path

# Database configuration
DATABASE_PATH = "data/mbetterclient.db"

def check_database_schema():
    """Check database schema and table structure"""
    try:
        print("Checking database schema...")

        # Connect to the database directly
        conn = sqlite3.connect(DATABASE_PATH)
        cursor = conn.cursor()

        # Get all tables in the database
        cursor.execute("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name;")
        tables = cursor.fetchall()

        print(f"Found {len(tables)} tables:")
        for table in tables:
            print(f"  - {table[0]}")

        # Check if bet_details table exists
        bet_details_exists = any(table[0] == 'bet_details' for table in tables)
        print(f"\nbet_details table exists: {bet_details_exists}")

        # Get schema for bets table
        cursor.execute("SELECT sql FROM sqlite_master WHERE type='table' AND name='bets';")
        bets_schema = cursor.fetchone()
        if bets_schema:
            print(f"\nBets table schema:")
            print(bets_schema[0])

        # Get schema for bet_details table if it exists
        if bet_details_exists:
            cursor.execute("SELECT sql FROM sqlite_master WHERE type='table' AND name='bet_details';")
            bet_details_schema = cursor.fetchone()
            if bet_details_schema:
                print(f"\nBet details table schema:")
                print(bet_details_schema[0])

        # Check if there are any bets in the database
        cursor.execute("SELECT COUNT(*) FROM bets;")
        bet_count = cursor.fetchone()[0]
        print(f"\nTotal bets in database: {bet_count}")

        # Check if there are any bet_details in the database
        if bet_details_exists:
            cursor.execute("SELECT COUNT(*) FROM bet_details;")
            details_count = cursor.fetchone()[0]
            print(f"Total bet details in database: {details_count}")

        conn.close()
        print("\nDatabase schema check completed successfully")

    except Exception as e:
        print(f"Database schema check failed: {e}")
        import traceback
        traceback.print_exc()

if __name__ == "__main__":
    check_database_schema()