# Changelog

All notable changes to this project will be documented in this file.

## [1.2.0] - 2025-08-20

### Added
- **Qt Player Overlay System**: Dual overlay system with command-line switchable options between QWebEngineView and native Qt widgets
- **Admin Dashboard Shutdown**: Admin-only quit button in web dashboard with guaranteed force termination
- **Enhanced Overlay Templates**: Improved video overlay rendering with reduced JavaScript timing errors
- **Native Qt Widget Overlays**: Stable alternative to WebEngine overlays for better performance and reliability

### Fixed
- **Critical**: Qt player window close now properly exits entire application without deadlocks
- **Critical**: Ctrl+C signal handling fully restored and functional across all components
- **Critical**: Background thread management fixed - all threads now properly daemonized to prevent exit blocking
- **Critical**: Circular dependency deadlocks eliminated in shutdown process using force-exit mechanism
- **Critical**: WebEngine overlay timing errors significantly reduced with enhanced DOM readiness checks
- **Critical**: Desktop transparency bleed-through issues resolved by removing problematic transparency attributes
- Video controls removed for clean overlay-only interface
- JavaScript DOM safety enhanced with comprehensive error handling
- Qt threading architecture optimized for better stability

### Changed
- Background threads now run as daemon threads to prevent application exit blocking
- Qt signal integration enhanced with aboutToQuit signal handling for proper lifecycle management
- Shutdown message handling improved with sender-specific logic to avoid circular dependencies
- WebEngine readiness checks enhanced for safer overlay updates
- Force-exit mechanism implemented using os._exit(0) with delayed execution to bypass Qt event loop issues

### Technical Details
- Fixed closeEvent() in Qt player to remove forced os._exit(0) and allow proper Qt shutdown sequence
- Enhanced signal_handler() in main.py to detect Qt applications and use qt_app.quit() appropriately
- Modified ThreadManager to set daemon=True for all background threads ensuring clean process termination
- Added /api/system/shutdown endpoint with admin authentication and immediate HTTP response before force termination
- Implemented comprehensive background component cleanup in _qt_about_to_quit() method
- Added desktop transparency prevention by removing WA_TranslucentBackground window attribute
- Enhanced WebEngine overlay safety with try-catch blocks and DOM state validation

## [1.1.0] - 2025-08-19

### Added
- Enhanced token creation workflow with professional modal dialogs
- Comprehensive troubleshooting section in README
- Default admin user creation on first run
- Permanent token deletion functionality
- Section-based configuration updates
- Database operation stability improvements

### Fixed
- **Critical**: Application now exits gracefully with single Ctrl+C press
- **Critical**: API tokens properly display after creation in web interface
- **Critical**: User creation now saves properly and displays immediately
- **Critical**: Configuration updates through web dashboard now work correctly
- **Critical**: Qt player thread freezing issue resolved by running Qt event loop on main thread
- SQLAlchemy session binding issues causing data access errors
- Token revocation now permanently deletes tokens from database
- Frontend JavaScript token management and display
- Database operations extract data before session closure
- Signal handler optimization with reduced timeouts
- Web dashboard routing and static file loading issues
- ConfigManager missing update_section method
 
### Changed
- Reduced application shutdown timeouts for faster exit (10s→3s, 5s→2s)
- Updated README with comprehensive troubleshooting guide
- Enhanced API documentation with all endpoints
- Improved error handling across all components
- Qt player now runs Qt event loop on main thread instead of background thread

### Technical Details
- Fixed database session binding by extracting data to dictionaries
- Added proper signal handling flow: signal → shutdown event → cleanup → exit
- Enhanced frontend with Bootstrap modal dialogs for token display
- Implemented section-based configuration management
- Added comprehensive session lifecycle management
- Qt player thread freezing fixed by running Qt event loop on main thread instead of background thread
- Qt player no longer inherits from ThreadedComponent to comply with Qt threading requirements
- Message processing for Qt player now runs in a separate thread while Qt event loop runs on main thread

## [1.0.0] - 2025-08-15

### Added
- Initial release of MbetterClient
- PyQt video player with overlay support
- Flask web dashboard with authentication
- REST API client with configurable endpoints
- Multi-threaded architecture with message bus
- SQLite database with versioning system
- PyInstaller build configuration
- Cross-platform support (Windows, Linux, macOS)
- JWT and long-lived API token management
- User management system
- Configuration management interface
- Video upload and playback testing

### Features
- Fullscreen and windowed video playback modes
- Customizable video overlay templates
- Web-based administration interface
- API token creation and management
- User authentication and authorization
- Database migrations system
- Message-based inter-thread communication
- Comprehensive logging system
- Configuration persistence