/**
 * English
 *
 * LCD Menu Messages
 * Please note these are limited to 17 characters!
 *
 */
#ifndef LANGUAGE_EN_H
#define LANGUAGE_EN_H

#define WELCOME_MSG                         MACHINE_NAME " ready."
#define MSG_SD_INSERTED                     "Card inserted"
#define MSG_SD_REMOVED                      "Card removed"
#define MSG_MAIN                            "Main"
#define MSG_AUTOSTART                       "Autostart"
#define MSG_DISABLE_STEPPERS                "Disable steppers"
#define MSG_AUTO_HOME                       "Auto home"
#define MSG_BED_SETTING                     "Bed Setting"
#define MSG_SET_HOME_OFFSETS                "Set home offsets"
#define MSG_SET_ORIGIN                      "Set origin"
#define MSG_PREHEAT_PLA                     "Preheat PLA"
#define MSG_PREHEAT_PLA0                    "Preheat PLA 1"
#define MSG_PREHEAT_PLA1                    "Preheat PLA 2"
#define MSG_PREHEAT_PLA2                    "Preheat PLA 3"
#define MSG_PREHEAT_PLA3                    "Preheat PLA 4"
#define MSG_PREHEAT_PLA0123                 "Preheat PLA All"
#define MSG_PREHEAT_PLA_BEDONLY             "Preheat PLA Bed"
#define MSG_PREHEAT_PLA_SETTINGS            "Preheat PLA conf"
#define MSG_PREHEAT_ABS                     "Preheat ABS"
#define MSG_PREHEAT_ABS0                    "Preheat ABS 1"
#define MSG_PREHEAT_ABS1                    "Preheat ABS 2"
#define MSG_PREHEAT_ABS2                    "Preheat ABS 3"
#define MSG_PREHEAT_ABS3                    "Preheat ABS 4"
#define MSG_PREHEAT_ABS0123                 "Preheat ABS All"
#define MSG_PREHEAT_ABS_BEDONLY             "Preheat ABS Bed"
#define MSG_PREHEAT_ABS_SETTINGS            "Preheat ABS conf"
#define MSG_PREHEAT_GUM                     "Preheat GUM"
#define MSG_PREHEAT_GUM0                    "Preheat GUM 1"
#define MSG_PREHEAT_GUM1                    "Preheat GUM 2"
#define MSG_PREHEAT_GUM2                    "Preheat GUM 3"
#define MSG_PREHEAT_GUM3                    "Preheat GUM 4"
#define MSG_PREHEAT_GUM_BEDONLY             "Preheat GUM Bed"
#define MSG_PREHEAT_GUM_SETTINGS            "Preheat GUM conf"
#define MSG_COOLDOWN                        "Cooldown"
#define MSG_SWITCH_PS_ON                    "Switch power on"
#define MSG_SWITCH_PS_OFF                   "Switch power off"
#define MSG_EXTRUDE                         "Extrude"
#define MSG_RETRACT                         "Retract"
#define MSG_MOVE_AXIS                       "Move axis"
#define MSG_MOVE_X                          "Move X"
#define MSG_MOVE_Y                          "Move Y"
#define MSG_MOVE_Z                          "Move Z"
#define MSG_MOVE_E                          "Extruder"
#define MSG_MOVE_E1                         "Extruder2"
#define MSG_MOVE_E2                         "Extruder3"
#define MSG_MOVE_E3                         "Extruder4"
#define MSG_MOVE_01MM                       "Move 0.1mm"
#define MSG_MOVE_1MM                        "Move 1mm"
#define MSG_MOVE_10MM                       "Move 10mm"
#define MSG_SPEED                           "Speed"
#define MSG_NOZZLE                          "Nozzle"
#define MSG_NOZZLE1                         "Nozzle2"
#define MSG_NOZZLE2                         "Nozzle3"
#define MSG_NOZZLE3                         "Nozzle4"
#define MSG_BED                             "Bed"
#define MSG_FAN_SPEED                       "Fan speed"
#define MSG_FLOW                            "Flow"
#define MSG_FLOW0                           "Flow 0"
#define MSG_FLOW1                           "Flow 1"
#define MSG_FLOW2                           "Flow 2"
#define MSG_FLOW3                           "Flow 3"
#define MSG_CONTROL                         "Control"
#define MSG_MIN                             " \002 Min"
#define MSG_MAX                             " \002 Max"
#define MSG_FACTOR                          " \002 Fact"
#define MSG_AUTOTEMP                        "Autotemp"
#define MSG_ON                              "On "
#define MSG_OFF                             "Off"
#define MSG_PID_P                           "PID-P"
#define MSG_PID_I                           "PID-I"
#define MSG_PID_D                           "PID-D"
#define MSG_PID_P1                          "PID-P E2"
#define MSG_PID_I1                          "PID-I E2"
#define MSG_PID_D1                          "PID-D E2"
#define MSG_PID_P2                          "PID-P E3"
#define MSG_PID_I2                          "PID-I E3"
#define MSG_PID_D2                          "PID-D E3"
#define MSG_PID_P3                          "PID-P E4"
#define MSG_PID_I3                          "PID-I E4"
#define MSG_PID_D3                          "PID-D E4"
#define MSG_ACC                             "Accel"
#define MSG_VXY_JERK                        "Vxy-jerk"
#define MSG_VZ_JERK                         "Vz-jerk"
#define MSG_VE_JERK                         "Ve-jerk"
#define MSG_VMAX                            "Vmax "
#define MSG_X                               "x"
#define MSG_Y                               "y"
#define MSG_Z                               "z"
#define MSG_E                               "e"
#define MSG_VMIN                            "Vmin"
#define MSG_VTRAV_MIN                       "VTrav min"
#define MSG_AMAX                            "Amax "
#define MSG_A_RETRACT                       "A-retract"
#define MSG_XSTEPS                          "Xsteps/mm"
#define MSG_YSTEPS                          "Ysteps/mm"
#define MSG_ZSTEPS                          "Zsteps/mm"
#define MSG_E0STEPS                         "E0steps/mm"
#define MSG_E1STEPS                         "E1steps/mm"
#define MSG_E2STEPS                         "E2steps/mm"
#define MSG_E3STEPS                         "E3steps/mm"
#define MSG_TEMPERATURE                     "Temperature"
#define MSG_MOTION                          "Motion"
#define MSG_VOLUMETRIC                      "Filament"
#define MSG_VOLUMETRIC_ENABLED              "E in mm3"
#define MSG_FILAMENT_SIZE_EXTRUDER_0        "Fil. Dia. 1"
#define MSG_FILAMENT_SIZE_EXTRUDER_1        "Fil. Dia. 2"
#define MSG_FILAMENT_SIZE_EXTRUDER_2        "Fil. Dia. 3"
#define MSG_FILAMENT_SIZE_EXTRUDER_3        "Fil. Dia. 4"
#define MSG_CONTRAST                        "LCD contrast"
#define MSG_STORE_EPROM                     "Store memory"
#define MSG_LOAD_EPROM                      "Load memory"
#define MSG_RESTORE_FAILSAFE                "Restore failsafe"
#define MSG_REFRESH                         "Refresh"
#define MSG_WATCH                           "Info screen"
#define MSG_PREPARE                         "Prepare"
#define MSG_TUNE                            "Tune"
#define MSG_PAUSE_PRINT                     "Pause print"
#define MSG_RESUME_PRINT                    "Resume print"
#define MSG_STOP_PRINT                      "Stop print"
#define MSG_CARD_MENU                       "Print from SD"
#define MSG_NO_CARD                         "No SD card"
#define MSG_DWELL                           "Sleep..."
#define MSG_USERWAIT                        "Wait for user..."
#define MSG_RESUMING                        "Resuming print"
#define MSG_PRINT_ABORTED                   "Print aborted"
#define MSG_NO_MOVE                         "No move."
#define MSG_KILLED                          "KILLED. "
#define MSG_STOPPED                         "STOPPED. "
#define MSG_CONTROL_RETRACT                 "Retract mm"
#define MSG_CONTROL_RETRACT_SWAP            "Swap Re.mm"
#define MSG_CONTROL_RETRACTF                "Retract  V"
#define MSG_CONTROL_RETRACT_ZLIFT           "Hop mm"
#define MSG_CONTROL_RETRACT_RECOVER         "UnRet +mm"
#define MSG_CONTROL_RETRACT_RECOVER_SWAP    "S UnRet+mm"
#define MSG_CONTROL_RETRACT_RECOVERF        "UnRet  V"
#define MSG_AUTORETRACT                     "AutoRetr."
#define MSG_FILAMENTCHANGE                  "Change filament"
#define MSG_INIT_SDCARD                     "Init. SD card"
#define MSG_CNG_SDCARD                      "Change SD card"
#define MSG_ZPROBE_OUT                      "Z probe out. bed"
#define MSG_POSITION_UNKNOWN                "Home X/Y before Z"
#define MSG_ZPROBE_ZOFFSET                  "Z Offset"
#define MSG_BABYSTEP_X                      "Babystep X"
#define MSG_BABYSTEP_Y                      "Babystep Y"
#define MSG_BABYSTEP_Z                      "Babystep Z"
#define MSG_ENDSTOP_ABORT                   "Endstop abort"

#define MSG_RECTRACT                        "Rectract"
#define MSG_LASER                           "Laser Preset"
#define MSG_CONFIG                          "Configuration"
#define MSG_BAUDRATE                        "Baudrate"
#define MSG_E_BOWDEN_LENGTH                 "Extrude " STRINGIFY(BOWDEN_LENGTH) "mm"
#define MSG_R_BOWDEN_LENGTH                 "Retract " STRINGIFY(BOWDEN_LENGTH) "mm"
#define MSG_PURGE_XMM                       "Purge " STRINGIFY(LCD_PURGE_LENGTH) "mm"
#define MSG_RETRACT_XMM                     "Retract " STRINGIFY(LCD_RETRACT_LENGTH) "mm"

#ifdef DELTA
  #define MSG_DELTA_CALIBRATE             "Delta Calibration"
  #define MSG_DELTA_CALIBRATE_X           "Calibrate X"
  #define MSG_DELTA_CALIBRATE_Y           "Calibrate Y"
  #define MSG_DELTA_CALIBRATE_Z           "Calibrate Z"
  #define MSG_DELTA_CALIBRATE_CENTER      "Calibrate Center"
#endif // DELTA

#ifdef FIRMWARE_TEST
#define MSG_FWTEST_YES                      "Put the Y command to go next"
#define MSG_FWTEST_NO                       "Put the N command to go next"
#define MSG_FWTEST_YES_NO                   "Put the Y or N command to go next"
#define MSG_FWTEST_ENDSTOP_ERR              "ENDSTOP ERROR! Check wire and connection"
#define MSG_FWTEST_PRESS                    "Press and hold the endstop "
#define MSG_FWTEST_INVERT                   "Reverse value in "
#define MSG_FWTEST_XAXIS                    "Has the nozzle moved to the right?"
#define MSG_FWTEST_YAXIS                    "Has the nozzle moved forward?"
#define MSG_FWTEST_ZAXIS                    "Has the nozzle moved up?"
#define MSG_FWTEST_01                       "Manually move the axes X, Y and Z away from the endstop"
#define MSG_FWTEST_02                       "Do you want check ENDSTOP?"
#define MSG_FWTEST_03                       "Start check ENDSTOP"
#define MSG_FWTEST_04                       "Start check MOTOR"
#define MSG_FWTEST_ATTENTION                "ATTENTION! Check that the three axes are more than 5 mm from the endstop!"
#endif // FIRMWARE_TEST

#endif // LANGUAGE_EN_H
