/**
 * Japanese (Kana UTF8 version)
 *
 * LCD Menu Messages
 * See also documentation/LCDLanguageFont.md
 *
 */
 
#ifndef LANGUAGE_KANA_UTF_H
#define LANGUAGE_KANA_UTF_H

#define MAPPER_E382E383
// Define SIMULATE_ROMFONT to see what is seen on the character based display defined in Configuration.h
//#define SIMULATE_ROMFONT
#define DISPLAY_CHARSET_ISO10646_KANA

// This is very crude replacement of the codes used in language_kana.h from somebody who really does not know what he is doing.
// Just to show the potential benefit of unicode. 
// This translation can be improved by using the full charset of unicode codeblock U+30A0 to U+30FF.

// 片仮名表示定義
#define WELCOME_MSG                         MACHINE_NAME " ready."
#define MSG_SD_INSERTED                     "セード ンウニユウアレマシタ"          // "Card inserted"
#define MSG_SD_REMOVED                      "セードゼアリマセン"               // "Card removed"
#define MSG_MAIN                            "ナイン"                        // "Main"
#define MSG_AUTOSTART                       "ヅドウセイシ"                   // "Autostart"
#define MSG_DISABLE_STEPPERS                "モーターデンゲン オフ"             // "Disable steppers"
#define MSG_AUTO_HOME                       "ゲンテンニイドウ"                // "Auto home"
#define MSG_SET_HOME_OFFSETS                "キヅユンオフセツトセツテイ"         // "Set home offsets"
#define MSG_SET_ORIGIN                      "キヅユンセツト"                 // "Set origin"
#define MSG_PREHEAT_PLA                     "PLA ヨネシ"                    // "Preheat PLA"
#define MSG_PREHEAT_PLA_N                   MSG_PREHEAT_PLA " "
#define MSG_PREHEAT_PLA_ALL                 MSG_PREHEAT_PLA " スベテ"      // " All"
#define MSG_PREHEAT_PLA_BEDONLY             MSG_PREHEAT_PLA " ベツド"    // "Bed"
#define MSG_PREHEAT_PLA_SETTINGS            MSG_PREHEAT_PLA " セツテイ"     // "conf"
#define MSG_PREHEAT_ABS                     "ABS ヨネシ"                    // "Preheat ABS"
#define MSG_PREHEAT_ABS_N                   MSG_PREHEAT_ABS " "
#define MSG_PREHEAT_ABS_ALL                 MSG_PREHEAT_ABS " スベテ"      // " All"
#define MSG_PREHEAT_ABS_BEDONLY             MSG_PREHEAT_ABS " ベツド"    // "Bed"
#define MSG_PREHEAT_ABS_SETTINGS            MSG_PREHEAT_ABS " セツテイ"    // "conf"
#define MSG_COOLDOWN                        "セネシテイシ"                    // "Cooldown"
#define MSG_SWITCH_PS_ON                    "デンケゾ オン"                 // "Switch power on"
#define MSG_SWITCH_PS_OFF                   "デンケゾ オフ"                 // "Switch power off"
#define MSG_EXTRUDE                         "オシダシ"                     // "Extrude"
#define MSG_RETRACT                         "リトラケト"                     // "Retract"
#define MSG_MOVE_AXIS                       "ヅケイドウ"                   // "Move axis"
#define MSG_MOVE_X                          "Xヅケ イドウ"                 // "Move X"
#define MSG_MOVE_Y                          "Yヅケ イドウ"                 // "Move Y"
#define MSG_MOVE_Z                          "Zヅケ イドウ"                 // "Move Z"
#define MSG_MOVE_E                          "エケストルーダー"                // "Extruder"
#define MSG_MOVE_01MM                       "0.1mm イドウ"                 // "Move 0.1mm"
#define MSG_MOVE_1MM                        "  1mm イドウ"                 // "Move 1mm"
#define MSG_MOVE_10MM                       " 10mm イドウ"                 // "Move 10mm"
#define MSG_SPEED                           "スヒ゜ード"                     // "Speed"
#define MSG_NOZZLE                          "ノズル"                       // "Nozzle"
#define MSG_BED                             "ベツド"                     // "Bed"
#define MSG_FAN_SPEED                       "ファンンケド"                    // "Fan speed"
#define MSG_FLOW                            "オケリリョウ"                     // "Flow"
#define MSG_CONTROL                         "コントロール"                    // "Control"
#define MSG_MIN                             LCD_STR_THERMOMETER " Min"
#define MSG_MAX                             LCD_STR_THERMOMETER " Max"
#define MSG_FACTOR                          LCD_STR_THERMOMETER " Fact"
#define MSG_AUTOTEMP                        "ヅドウオンド"                  // "Autotemp"
#define MSG_ON                              "On "
#define MSG_OFF                             "Off"
#define MSG_PID_P                           "PID-P"
#define MSG_PID_I                           "PID-I"
#define MSG_PID_D                           "PID-D"
#define MSG_PID_C                           "PID-C"
#define MSG_ACC                             "センケド"                     // "Accel"
#define MSG_VXY_JERK                        "Vxy-jerk"
#define MSG_VZ_JERK                         "Vz-jerk"
#define MSG_VE_JERK                         "Ve-jerk"
#define MSG_VMAX                            "Vmax "
#define MSG_X                               "x"
#define MSG_Y                               "y"
#define MSG_Z                               "z"
#define MSG_E                               "e"
#define MSG_VMIN                            "Vmin"
#define MSG_VTRAV_MIN                       "VTrav min"
#define MSG_AMAX                            "Amax "
#define MSG_A_RETRACT                       "A-retract"
#define MSG_XSTEPS                          "Xsteps/mm"
#define MSG_YSTEPS                          "Ysteps/mm"
#define MSG_ZSTEPS                          "Zsteps/mm"
#define MSG_ESTEPS                          "Esteps/mm"
#define MSG_TEMPERATURE                     "オンド"                      // "Temperature"
#define MSG_MOTION                          "ウゴキセツテイ"                // "Motion"
#define MSG_VOLUMETRIC                      "フィラナント"                    // "Filament"
#define MSG_VOLUMETRIC_ENABLED              "E in mm3"
#define MSG_FILAMENT_SIZE_EXTRUDER_0        "Fil. Dia. 1"
#define MSG_FILAMENT_SIZE_EXTRUDER_1        "Fil. Dia. 2"
#define MSG_FILAMENT_SIZE_EXTRUDER_2        "Fil. Dia. 3"
#define MSG_FILAMENT_SIZE_EXTRUDER_3        "Fil. Dia. 4"
#define MSG_CONTRAST                        "LCDコントラスト"                 // "LCD contrast"
#define MSG_STORE_EPROM                     "ナモリヘセケノウ"                 // "Store memory"
#define MSG_LOAD_EPROM                      "ナモリセラヨミbaミ"               // "Load memory"
#define MSG_RESTORE_FAILSAFE                "セツテイリセツト"               // "Restore failsafe"
#define MSG_REFRESH                         "リフレツシユ"                  // "Refresh"
#define MSG_WATCH                           "インフォ"                     // "Info screen"
#define MSG_PREPARE                         "ヅユンゼセツテイ"             //"Prepare"
#define MSG_TUNE                            "チョウセイ"                    // "Tune"
#define MSG_PAUSE_PRINT                     "イチヅテイシ"                  // "Pause print"
#define MSG_RESUME_PRINT                    "プリントアイセイ"                // "Resume print"
#define MSG_STOP_PRINT                      "プリントテイシ"                 // "Stop print"
#define MSG_CARD_MENU                       "SDセードセラプリント"            // "Print from SD"
#define MSG_NO_CARD                         "SDセードゼアリマセン"            // "No SD card"
#define MSG_DWELL                           "スリープ"                     // "Sleep..."
#define MSG_USERWAIT                        "シバラケオマチケダアイ"           // "Wait for user..."
#define MSG_RESUMING                        "プリントアイセイ"                // "Resuming print"
#define MSG_PRINT_ABORTED                   "プリントチユウシアレマシタ"          // "Print aborted"
#define MSG_NO_MOVE                         "ウゴキマセン"                  // "No move."
#define MSG_KILLED                          "ショウキョ"                     // "KILLED. "
#define MSG_STOPPED                         "テイシシマシタ"                  // "STOPPED. "
#define MSG_CONTROL_RETRACT                 "Retract mm"
#define MSG_CONTROL_RETRACT_SWAP            "Swap Re.mm"
#define MSG_CONTROL_RETRACTF                "Retract  V"
#define MSG_CONTROL_RETRACT_ZLIFT           "Hop mm"
#define MSG_CONTROL_RETRACT_RECOVER         "UnRet +mm"
#define MSG_CONTROL_RETRACT_RECOVER_SWAP    "S UnRet+mm"
#define MSG_CONTROL_RETRACT_RECOVERF        "UnRet  V"
#define MSG_AUTORETRACT                     "AutoRetr."
#define MSG_FILAMENTCHANGE                  "フィラナントコウセン"               // "Change filament"
#define MSG_INIT_SDCARD                     "SDセードアイヨミコミ"              // "Init. SD card"
#define MSG_CNG_SDCARD                      "SDセードコウセン"                // "Change SD card"
#define MSG_ZPROBE_OUT                      "Zプローブ ベツトnゼイ"         // "Z probe out. bed"
#define MSG_POSITION_UNKNOWN                "ゲンテンハXYイドウゴZ"           // "Home X/Y before Z"
#define MSG_ZPROBE_ZOFFSET                  "Zオフセツト"                   // "Z Offset"
#define MSG_BABYSTEP_X                      "ゼドウ X"                    // "Babystep X"
#define MSG_BABYSTEP_Y                      "ゼドウ Y"                    // "Babystep Y"
#define MSG_BABYSTEP_Z                      "ゼドウ Z"                    // "Babystep Z"
#define MSG_ENDSTOP_ABORT                   "Endstop abort"

#ifdef DELTA_CALIBRATION_MENU
    #define MSG_DELTA_CALIBRATE             "Delta Calibration"
    #define MSG_DELTA_CALIBRATE_X           "Calibrate X"
    #define MSG_DELTA_CALIBRATE_Y           "Calibrate Y"
    #define MSG_DELTA_CALIBRATE_Z           "Calibrate Z"
    #define MSG_DELTA_CALIBRATE_CENTER      "Calibrate Center"
#endif // DELTA_CALIBRATION_MENU

#endif // LANGUAGE_KANA_UTF_H
