/**
 * @file NexNumber.h
 *
 * The definition of class NexNumber.
 *
 * @author Wu Pengfei (email:<pengfei.wu@itead.cc>)
 * @date 2015/8/13
 *
 * @copyright
 * Copyright (C) 2014-2015 ITEAD Intelligent Systems Co., Ltd.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 */

#ifndef __NEXNUMBER_H__
#define __NEXNUMBER_H__

#include "NexTouch.h"
#include "NexHardware.h"
/**
 * @addtogroup Component 
 * @{
 */

/**
 * NexTNumber component.
 */
class NexNumber: public NexTouch
{
public: /* methods */
    /**
     * @copydoc NexObject::NexObject(uint8_t pid, uint8_t cid, const char *name);
     */
    NexNumber(uint8_t pid, uint8_t cid, const char *name);

    /**
     * Get number attribute of component.
     *
     * @param buffer - buffer storing text returned.
     * @param len - length of buffer.
     * @return The real length of text returned.
     */
    bool getValue(uint32_t *number);

    /**
     * Set number attribute of component.
     *
     * @param buffer - number buffer.
     * @return true if success, false for failure.
     */
    bool setValue(uint32_t number);
};

/**
 * @}
 */

#endif /* #ifndef __NEXNUMBER_H__ */
