/**
 * MK & MK4due 3D Printer Firmware
 *
 * Based on Marlin, Sprinter and grbl
 * Copyright (C) 2011 Camiel Gubbels / Erik van der Zalm
 * Copyright (C) 2013 - 2016 Alberto Cotronei @MagoKimbra
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "../../base.h"

#if ENABLED(MESH_BED_LEVELING)

  mesh_bed_leveling mbl;

  mesh_bed_leveling::mesh_bed_leveling() { reset(); }

  void mesh_bed_leveling::reset() {
    active = 0;
    z_offset = 0;
    for (int8_t y = MESH_NUM_Y_POINTS; y--;)
      for (int8_t x = MESH_NUM_X_POINTS; x--;)
        z_values[y][x] = 0;
  }

#endif  // MESH_BED_LEVELING
