---
author: "Franco (nextime) Lanza"
date: 2018-01-19
linktitle: "Rain water harvesting"
categories: [  "docs", "info" ]
tags: [ "HTW",
        "save_water",
        "source_water",
        "rain_water"
      ]
next: /tutorials/github-pages-blog
prev: /tutorials/automated-deployments
title: "Rain water harvesting"
weight: 10
#authorAvatar: img/logo.png
image: img/rain.jpg

---

Harvesting rain is a great way to have an alternative and low cost source of water, and is one of the oldest and well know one (of course!).

The quality of rain water depend on many factors, but usually isn't bad and rain water can be used for a lot of things, even as a potable water paying a little bit of attention.

Even in drought areas like Cape Town harvesting rain can give you a good quantity of more water. In pre-drought years the medium rainfall in Cape Town was around 788mm per year. With a 100 square meters of roof, a medium size for a private home in this area, will give you up to ~ 79000 liters of water. In 2017, the worst year ever, the rainfall in Cape Town was only 153mm of rain in whole year. Even with such low rain, 100 square meters would give you 15000 liters of water. Not a huge quantity in a year, but not so bad.

The best way to collect rain water is of course to maximize the surface you use to catch the rain, and usual this mean to use your roof. This has the advantage that you can also use the gutters you already have, and just modify them to collect all the water you can in some tanks.

![Rain Water from roof](/img/rainharvesting.jpg)
![Rain Water from roof 2](/img/rainharvesting2.jpg)

## Rain water: possible use

Rain water can be usefull for a lot of different usages, from flushing toilets to gardening, from using it for bath and shower to even drink it. 

The treatment you will need to do on it strictly depend on how you are collecting and eventually stocking it and, of course, mainly on what use you will have for it.

Assuming you would like to use it for flushing toilets very little is needed to do, only eventualy a little bit of sterilization to avoid in-tank bacterial and algaes growth, 
a little bit of chlorine would be enough.

If you use it for gardening you can even avoid any threatment at all.

Different is if you intend to use it for showers or even more if you intend to drink it, as there are some dangers that need to take in to account.

## Rain water potabilization

Rain water has been used and continue to be used all around the world as a relatively safe source of drinking water. But sadly isn't as pure as you may think, and assuming it's safe to drink it is rather a dangerous assumption.

### first issue: polluttants in the air

Rain water come from clouds. And clouds stay in the sky for a lot of time in a long journey in our low atmosphere, and eventually falls to the ground.

During all this time it capture a lot of things out of the air, human polluttants but also insects, algaes, little pieces of vegetals and so on. And the bad part is that testing it would NOT give you any usefull information to forecast the future quality, to know exactly what it contains you would need to test it at every single rain event.

For this reason if you want to drink it you MUST consider to filter it. An activated carbon filter, a reverse osmosis filter or at least a slow sand filter is something you really need to take in account.

### second issue: your roof isn't clean!

If you collect your water from the gutters, that's usually the best way to maximize your collecting surface, you must consider what the water can whash from your roof. Of course the kind of roof you have is also something you must take in account, but that's not the bad part. The bad part is that your roof is probably also the toilet for birds, and when you are harvesting rain you are collecting the water used to whash your roof from birds poo.

Bird poo in your water translate to high concentration of nitrates, and that pose a serious health danger. To remove them from your drinking water you will need to filter it in some way. Evaporation is not so fast nor convenient, but it works good. Another way is reverse osmosis, ion filters do the job as well. Activated carbon DOESN'T work for that, so, don't use it.

If you have time and at least two tanks, you can filter it slowly by gravity, but probably a pump to pressurize it and the right inline filter is more convenient ( but more expensive ).

### third issue: bacterial and algaes in-tank growth

As usual stocking water in a closed tank, maybe an exposed to sun tank, create the perfect environment for bacterial and algaes to grow. 

A good way to avoid that is in-tank sterilization, you can easily do it both by adding some chlorine ( drinking level, it isn't a pool! ) or even by using a submersible UV lamp. Another way i haven't tested is by Ozonation, that is, adding ozone. For what i can see is pretty expensive to build and/or buy an ozonation system, so, i would go for one of the other two ways.

Of course you will also need to take the tank as clean as you can, so, a gross filtering before the tank to remove leafs and other big debris coming from your gutter it's a great idea, and maybe also a debris by fall pre-tank filter should be a good idea and will help also with lime and dust from your roof.

The UV lamps will work great, but the good old chlorination have also another benefit: it will help also to maintain bacterial and algaes free your piping.

### fourth issue: high acidity

Rain water is usually more acid ( lower PH ) than other sources cause of the lack of minerals in the solution. For sterilization this can also be a good thing as chlorine works better in more acid water, but if you drink mainly acid water for long term it has bed effects on your health.

If you then evaporate it or if you use reverse osmosis, your water will be even closer to demineralizated water, and that's not good if your goal is to potabilize it.

To solve that issue there are some mineralization filters, usually used with reverse osmosis filters, that can re-establish the right PH level and add some useful minerals that will make your water perfect for drinking.
