/*
 * Copyright (c) 2014-2016 Cesanta Software Limited
 * All rights reserved
 */

#include "bm222.h"

#include "mongoose.h"
#include "cs_dbg.h"

#include "i2c_if.h"

#define BM222_REG_FIFO_STATUS 0x0e

#define BM222_REG_PMU_BW 0x10
#define BM222_PMU_BW_7_81_HZ 0x8
#define BM222_PMU_BW_31_25_HZ 0xA
#define BM222_PMU_BW_62_5_HZ 0xB
#define BM222_PMU_BW_125_HZ 0xC

#define BM222_REG_BGW_SOFTRESET 0x14
#define BM222_DO_SOFT_RESET 0xB6

#define BM222_REG_FIFO_CONFIG_1 0x3e
#define BM222_FIFO_MODE_FIFO 0x40
#define BM222_FIFO_DATA_ALL 0

#define BM222_REG_FIFO_DATA 0x3f

struct bm222_ctx *bm222_init(uint8_t addr) {
  struct bm222_ctx *ctx = (struct bm222_ctx *) calloc(1, sizeof(*ctx));
  if (ctx == NULL) return NULL;
  ctx->addr = addr;
  {
    unsigned char val[2] = {BM222_REG_BGW_SOFTRESET, BM222_DO_SOFT_RESET};                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   