# <img src="http://www.cesanta.com/hubfs/www.cesanta.com/Images/mongoose_library.png" width="64" height="64"> Mongoose - Embedded Web Server / Embedded Networking Library

![](https://img.shields.io/badge/license-GPL_2-green.svg "License")

Mongoose is ideal for embedded environments. It has been designed
for connecting devices and bringing them online. On the market since 2004,
used by vast number of open source and
commercial products - it even runs on space stations!
Mongoose makes embedded network programming fast, robust, and easy.

If you're looking for a pre-compiled Windows or Mac binary,
- [Download pre-compiled Mongoose web server binary](https://www.cesanta.com/products/binary)

Alternatively,

- [Download Mongoose Source Code here](http://hubs.ly/H01bWvx0)
- [Check our latest releases] (https://github.com/cesanta/mongoose/releases)
- [Read User Guide and API reference](https://docs.cesanta.com/mongoose/dev)
- [Study mongoose example code](https://github.com/cesanta/mongoose/tree/master/examples)

If you are looking for a complete IoT platform with firmware and cloud compotent,
- [Check out Smart.js - a full stack IoT platform](https://github.com/cesanta/smart.js)

# Support
- [Support Forum - Ask your technical questions here] (http://forum.cesanta.com/index.php?p=/categories/smart-js)
- [Chat - Visit www.cesanta.com for our live chat] (http://www.cesanta.com)
- [Commercial one-to-one support - Available to all commercial license holders] (https://www.cesanta.com/services-support)

# Features

* Cross-platform: works on Linux/UNIX, MacOS, QNX, eCos, Windows, Android,
  iPhone, FreeRTOS (TI CC3200, ESP8266), etc
* Single-threaded, asynchronous, non-blocking core with simple event-based API
* Native support for [PicoTCP embedded TCP/IP stack](http://www.picotcp.com),
  [LWIP embedded TCP/IP stack](https://en.wikipedia.org/wiki/LwIP)
* Builtin protocols:
   - plain TCP, plain UDP, SSL/TLS (over TCP, one-way or two-way)
   - HTTP client, HTTP server
   - WebSocket client, WebSocket server
   - JSON-RPC client, JSON-RPC server
   - MQTT client, MQTT broker
   - CoAP client, CoAP server
   - DNS client, DNS server, async DNS resolver
* Tiny static and run-time footprint
* Source code is both ISO C and ISO C++ compliant
* Very easy to integrate: just copy
  [mongoose.c](https://raw.githubusercontent.com/cesanta/mongoose/master/mongoose.c) and
  [mongoose.h](https://raw.githubusercontent.com/cesanta/mongoose/master/mongoose.h)
  files to your build tree

# Licensing

Mongoose is released under commercial and [GNU GPL v.2](http://www.gnu.org/licenses/old-licenses/gpl-2.0.html) open source licenses.

Commercial Projects:
Once your project becomes commercialised GPLv2 licensing dictates that you need to either open your source fully or purchase a commercial license. Cesanta offer full, royalty-free commercial licenses without any GPL restrictions. If your needs require a custom license, we’d be happy to work on a solution with you. [Contact us for pricing.] (https://www.cesanta.com/contact)

Prototyping:
While your project is still in prototyping stage and not for sale, you can use Mongoose’s open source code without license restrictions.

# Dashboard Example

Mongoose is often used to implement device dashboards and real-time
data exchange over Websocket. Here is a dashboard example that illustrates
the functionality:

![](http://www.cesanta.com/hubfs/www.cesanta.com/diagrams/dash_mongoose_diagram.png)

[Developing a new product? Contact us today to discuss how Mongoose can help
](https://www.cesanta.com/contact)

# Contributions

People who have agreed to the [Cesanta CLA] (https://docs.cesanta.com/contributors_la.shtml) can make contributions. Note that the CLA isn't a copyright assigment but rather a copyright license. You retain the copyright on your contributions.

[![Analytics](https://ga-beacon.appspot.com/UA-42732794-5/project-page)](https://github.com/cesanta/mongoose)
