from dmcfgstruct.helper import sizeof, setStruct, getStruct, odict

DM_INPUT_DESCR_STATUS=odict([
   (('name','zerotstr'),'32s'),
   (('mintime', 'raw'),'H'),
   (('enabled', 'raw'),'B'),
   (('type', 'raw'),'B')
])

DM_INPUT_DESCR_ACTION=odict([
   (('name', 'raw'),'32B'),
   (('ipdst', 'raw'),'4B'),
   (('timing', 'raw'),'H'),
   (('ctx', 'raw'),'H'),
   (('msg', 'raw'),'B'),
   (('act', 'raw'),'B')
])

DM_OUTPUT_DESCR=odict([
   (('name', 'zerotstr'),'32s'),
   (('ctx', 'raw'),'H'),
   (('runtime1', 'raw'),'H'),
   (('runtime2', 'raw'),'H'),
   (('interval1', 'raw'),'H'),
   (('interval2', 'raw'),'H'),
   (('retard1', 'raw'),'H'),
   (('retard2', 'raw'),'H'),
   (('relay1', 'raw'),'B'),
   (('relay2', 'raw'),'B'),
   (('NANC1', 'raw'),'B'),
   (('NANC2', 'raw'),'B'),
   (('amax1', 'raw'),'B'),
   (('amax2', 'raw'),'B'),
   (('type', 'raw'),'B'),
   (('enabled', 'raw'),'B')
])

DOMOVAR_OFFSET=256
DOMOVAR_STRUCTS_LEN=10
DM_VARS_OFFSET=512
DM_VARS_START=DM_VARS_OFFSET+1

DEFMAC_ADDR=0x1fbf0
DEFIP_ADDR=DEFMAC_ADDR+6
DEFHOSTNAME_ADDR=DEFIP_ADDR+4

STRNAMELEN=32
STRARGLEN=28

DM_VARS_ROOT_ADDR=DM_VARS_START
DM_VARS_ROOT_LENGHT=16

DM_VARS_ROOTPWD_ADDR=DM_VARS_ROOT_ADDR+DM_VARS_ROOT_LENGHT
DM_VARS_ROOTPWD_LENGHT=16

DM_VARS_USER_ADDR=DM_VARS_ROOTPWD_ADDR+DM_VARS_ROOTPWD_LENGHT
DM_VARS_USER_LENGHT=16

DM_VARS_USERPWD_ADDR=DM_VARS_USER_ADDR+DM_VARS_USER_LENGHT
DM_VARS_USERPWD_LENGHT=16

DM_VARS_UDPPWD_ADDR=DM_VARS_USERPWD_ADDR+DM_VARS_USERPWD_LENGHT
DM_VARS_UDPPWD_LENGHT=32

DM_VARS_STATUS_ADDR=DM_VARS_UDPPWD_ADDR+DM_VARS_UDPPWD_LENGHT
DM_VARS_STATUS_LENGHT=8

DM_VARS_INPUT_NAME_ADDR=DM_VARS_STATUS_ADDR+DM_VARS_STATUS_LENGHT
DM_VARS_INPUT_NAME_LENGHT=STRNAMELEN
DM_VARS_INPUT_NAME_NUM=12

DM_VARS_STATUS_DESCR_LEN=sizeof(DM_INPUT_DESCR_STATUS)
DM_VARS_STATUS_DESCR_PER_INPUT=4
DM_VARS_STATUS_DESCR_ADDR=DM_VARS_INPUT_NAME_ADDR+DM_VARS_INPUT_NAME_LENGHT*DM_VARS_INPUT_NAME_NUM
DM_VARS_STATUS_DESCR_LENGHT=DM_VARS_STATUS_DESCR_LEN*DM_VARS_STATUS_DESCR_PER_INPUT
DM_VARS_STATUS_DESCR_NUM=12

DM_VARS_ACTION_DESCR_LEN=sizeof(DM_INPUT_DESCR_ACTION)
DM_VARS_ACTION_DESCR_PER_STATUS=3
DM_VARS_ACTION_DESCR_ADDR=DM_VARS_STATUS_DESCR_ADDR+DM_VARS_STATUS_DESCR_LENGHT*DM_VARS_STATUS_DESCR_NUM
DM_VARS_ACTION_DESCR_LENGHT=DM_VARS_ACTION_DESCR_LEN*DM_VARS_ACTION_DESCR_PER_STATUS*DM_VARS_STATUS_DESCR_PER_INPUT
DM_VARS_ACTION_DESCR_NUM=12

DM_VARS_OUTPUT_DESCR_ADDR=DM_VARS_ACTION_DESCR_ADDR+(DM_VARS_ACTION_DESCR_LENGHT*DM_VARS_ACTION_DESCR_NUM)
DM_VARS_OUTPUT_DESCR_LENGHT=sizeof(DM_OUTPUT_DESCR)
DM_VARS_OUTPUT_DESCR_NUM=12


def getInputNameAddr(inp):
   return DM_VARS_INPUT_NAME_ADDR+(DM_VARS_INPUT_NAME_LENGHT*(inp-1))

def getInputTypeAddr(inp, stat):          
   return DM_VARS_STATUS_DESCR_ADDR+(DM_VARS_STATUS_DESCR_LENGHT*(inp-1))+(DM_VARS_STATUS_DESCR_LEN*stat)+35

def getInputStatusNameAddr(inp, stat):    
   return DM_VARS_STATUS_DESCR_ADDR+(DM_VARS_STATUS_DESCR_LENGHT*(inp-1))+(DM_VARS_STATUS_DESCR_LEN*stat)

def getInputEnabledAddr(inp, stat):      
   return DM_VARS_STATUS_DESCR_ADDR+(DM_VARS_STATUS_DESCR_LENGHT*(inp-1))+(DM_VARS_STATUS_DESCR_LEN*stat)+34

def getInputMinTimeAddr(inp, stat):      
   return DM_VARS_STATUS_DESCR_ADDR+(DM_VARS_STATUS_DESCR_LENGHT*(inp-1))+(DM_VARS_STATUS_DESCR_LEN*stat)+32


def getDstIpAddr(inp, stat, act):            
   return DM_VARS_ACTION_DESCR_ADDR+(DM_VARS_ACTION_DESCR_LENGHT*(inp-1)) \
          +((DM_VARS_ACTION_DESCR_LEN*((stat*DM_VARS_ACTION_DESCR_PER_STATUS)+act-1))+32) \
          *((stat*DM_VARS_ACTION_DESCR_PER_STATUS)+act-1)+32

def getInputMsgAddr(inp, stat, act):         
   return DM_VARS_ACTION_DESCR_ADDR+(DM_VARS_ACTION_DESCR_LENGHT*(inp-1)) \
          +(DM_VARS_ACTION_DESCR_LEN*(stat*DM_VARS_ACTION_DESCR_PER_STATUS)+act-1)+40

def getInputCtxAddr(inp, stat, act):
   return DM_VARS_ACTION_DESCR_ADDR+(DM_VARS_ACTION_DESCR_LENGHT*(inp-1)) \
          +(DM_VARS_ACTION_DESCR_LEN*((stat*DM_VARS_ACTION_DESCR_PER_STATUS)+act-1))+38

def getInputActAddr(inp, stat, act): 
   return DM_VARS_ACTION_DESCR_ADDR+(DM_VARS_ACTION_DESCR_LENGHT*(inp-1)) \
          +(DM_VARS_ACTION_DESCR_LEN*((stat*DM_VARS_ACTION_DESCR_PER_STATUS)+act-1))+41

def getInputTimingAddr(inp, stat, act): 
   return DM_VARS_ACTION_DESCR_ADDR+(DM_VARS_ACTION_DESCR_LENGHT*(inp-1)) \
          +(DM_VARS_ACTION_DESCR_LEN*((stat*DM_VARS_ACTION_DESCR_PER_STATUS)+act-1))+36

def getInputDstAddr(inp, stat, act):         
   return DM_VARS_ACTION_DESCR_ADDR+(DM_VARS_ACTION_DESCR_LENGHT*(inp-1)) \
          +(DM_VARS_ACTION_DESCR_LEN*((stat*DM_VARS_ACTION_DESCR_PER_STATUS)+act-1))


def getOutputNameAddr(out):                 
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))

def getOutputEnabledAddr(out):
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+53

def getOutputTypeAddr(out):                 
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+52

def getOutputCtxAddr(out):                  
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+32

def getOutputRelayAddr(out, rnum):          
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+45+rnum

def getOutputNANCAddr(out, rnum):           
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+47+rnum

def getOutputRuntimeAddr(out, rnum):        
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+34+((rnum-1)*2)

def getOutputIntervalAddr(out, rnum):       
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+38+((rnum-1)*2)

def getOutputRetardAddr(out, rnum):         
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+42+((rnum-1)*2)

def getOutputMaxAAddr(out, rnum):           
   return DM_VARS_OUTPUT_DESCR_ADDR+(DM_VARS_OUTPUT_DESCR_LENGHT*(out-1))+49+rnum

