from pybindgen import Module, FileCodeSink, param, retval, cppclass, typehandlers


import pybindgen.settings
import warnings

class ErrorHandler(pybindgen.settings.ErrorHandler):
    def handle_error(self, wrapper, exception, traceback_):
        warnings.warn("exception %r in wrapper %s" % (exception, wrapper))
        return True
pybindgen.settings.error_handler = ErrorHandler()


import sys
import foomodulegen_module1
import foomodulegen_module2

def module_init():
    root_module = Module('foo4', cpp_namespace='::')
    root_module.add_include('"foo.h"')
    return root_module

def register_types(module):
    root_module = module.get_root()
    
    root_module.begin_section('foomodulegen_module1')
    foomodulegen_module1.register_types(module)
    
    try:
        import foomodulegen_module1_local
    except ImportError:
        pass
    else:
        foomodulegen_module1_local.register_types(module)
    
    root_module.end_section('foomodulegen_module1')
    root_module.begin_section('foomodulegen_module2')
    foomodulegen_module2.register_types(module)
    
    try:
        import foomodulegen_module2_local
    except ImportError:
        pass
    else:
        foomodulegen_module2_local.register_types(module)
    
    root_module.end_section('foomodulegen_module2')
    module.add_container('std::map< std::string, int >', ('std::string', 'int'), container_type='map')
    module.add_container('std::set< unsigned int >', 'unsigned int', container_type='set')
    module.add_container('std::set< float >', 'float', container_type='set')
    
    ## Register a nested module for the namespace TopNs
    
    nested_module = module.add_cpp_namespace('TopNs')
    register_types_TopNs(nested_module)
    
    
    ## Register a nested module for the namespace std
    
    nested_module = module.add_cpp_namespace('std')
    register_types_std(nested_module)
    
    
    ## Register a nested module for the namespace xpto
    
    nested_module = module.add_cpp_namespace('xpto')
    register_types_xpto(nested_module)
    

def register_types_TopNs(module):
    root_module = module.get_root()
    
    
    ## Register a nested module for the namespace PrefixBottomNs
    
    nested_module = module.add_cpp_namespace('PrefixBottomNs')
    register_types_TopNs_PrefixBottomNs(nested_module)
    

def register_types_TopNs_PrefixBottomNs(module):
    root_module = module.get_root()
    

def register_types_std(module):
    root_module = module.get_root()
    

def register_types_xpto(module):
    root_module = module.get_root()
    

def register_methods(root_module):
    root_module.begin_section('foomodulegen_module1')
    foomodulegen_module1.register_methods(root_module)
    
    try:
        import foomodulegen_module1_local
    except ImportError:
        pass
    else:
        foomodulegen_module1_local.register_methods(root_module)
    
    root_module.end_section('foomodulegen_module1')
    root_module.begin_section('foomodulegen_module2')
    foomodulegen_module2.register_methods(root_module)
    
    try:
        import foomodulegen_module2_local
    except ImportError:
        pass
    else:
        foomodulegen_module2_local.register_methods(root_module)
    
    root_module.end_section('foomodulegen_module2')
    return

def register_functions(root_module):
    module = root_module
    root_module.begin_section('foomodulegen_module1')
    foomodulegen_module1.register_functions(root_module)
    
    try:
        import foomodulegen_module1_local
    except ImportError:
        pass
    else:
        foomodulegen_module1_local.register_functions(root_module)
    
    root_module.end_section('foomodulegen_module1')
    root_module.begin_section('foomodulegen_module2')
    foomodulegen_module2.register_functions(root_module)
    
    try:
        import foomodulegen_module2_local
    except ImportError:
        pass
    else:
        foomodulegen_module2_local.register_functions(root_module)
    
    root_module.end_section('foomodulegen_module2')
    register_functions_TopNs(module.get_submodule('TopNs'), root_module)
    register_functions_std(module.get_submodule('std'), root_module)
    register_functions_xpto(module.get_submodule('xpto'), root_module)
    return

def register_functions_TopNs(module, root_module):
    register_functions_TopNs_PrefixBottomNs(module.get_submodule('PrefixBottomNs'), root_module)
    return

def register_functions_TopNs_PrefixBottomNs(module, root_module):
    return

def register_functions_std(module, root_module):
    return

def register_functions_xpto(module, root_module):
    return

def main():
    out = FileCodeSink(sys.stdout)
    root_module = module_init()
    register_types(root_module)
    register_methods(root_module)
    register_functions(root_module)
    root_module.generate(out)

if __name__ == '__main__':
    main()

