from pybindgen import Module, FileCodeSink, param, retval, cppclass, typehandlers


import pybindgen.settings
import warnings

class ErrorHandler(pybindgen.settings.ErrorHandler):
    def handle_error(self, wrapper, exception, traceback_):
        warnings.warn("exception %r in wrapper %s" % (exception, wrapper))
        return True
pybindgen.settings.error_handler = ErrorHandler()


import sys

def module_init():
    root_module = Module('foo2', cpp_namespace='::')
    root_module.add_include('"foo.h"')
    return root_module

def register_types(module):
    root_module = module.get_root()
    
    module.add_class('AbstractBaseClass', allow_subclassing=True)
    module.add_class('AbstractBaseClass2', allow_subclassing=True)
    module.add_class('AbstractBaseClassImpl', parent=root_module['AbstractBaseClass'])
    module.add_class('AbstractXpto', allow_subclassing=True)
    module.add_class('AbstractXptoImpl', parent=root_module['AbstractXpto'])
    module.add_class('Box')
    module.add_class('CannotBeConstructed')
    module.add_class('ClassThatTakesFoo')
    module.add_class('ClassThatThrows', allow_subclassing=True)
    module.add_exception('Error')
    module.add_class('Foo', automatic_type_narrowing=True)
    module.add_class('Foobar', allow_subclassing=True)
    module.add_class('InterfaceId')
    module.add_class('MIRoot')
    module.add_class('ManipulatedObject')
    module.add_class('MapLike')
    module.add_class('PointerHolder', template_parameters=['Zbr'])
    module.add_class('ProtectedConstructor')
    module.add_class('ReferenceManipulator', allow_subclassing=True)
    module.add_class('SingletonClass', is_singleton=True)
    module.add_class('Socket', allow_subclassing=True)
    module.add_class('SomeObject', allow_subclassing=True)
    module.add_enum('', ['TYPE_FOO', 'TYPE_BAR'], outer_class=root_module['SomeObject'])
    module.add_enum('NestedEnum', ['FOO_TYPE_AAA', 'FOO_TYPE_BBB', 'FOO_TYPE_CCC'], outer_class=root_module['SomeObject'])
    module.add_enum('', ['CONSTANT_A', 'CONSTANT_B', 'CONSTANT_C'], outer_class=root_module['SomeObject'])
    module.add_class('NestedClass', automatic_type_narrowing=True, outer_class=root_module['SomeObject'])
    module.add_class('TestContainer', allow_subclassing=True)
    module.add_class('Tupl')
    module.add_class('UdpSocket', parent=root_module['Socket'])
    module.add_class('VectorLike')
    module.add_class('VectorLike2')
    module.add_class('Word')
    module.add_class('Zbr', allow_subclassing=True, memory_policy=cppclass.ReferenceCountingMethodsPolicy(incref_method='Ref', decref_method='Unref', peekref_method='GetReferenceCount'))
    module.add_class('Zoo', automatic_type_narrowing=True)
    root_module['Zoo'].implicitly_converts_to(root_module['Foo'])
    module.add_class('property', template_parameters=['std::string'])
    module.add_class('simple_struct_t')
    module.add_class('Bar', parent=root_module['Foo'])
    module.add_exception('DomainError', parent=root_module['Error'])
    module.add_class('MIBase1', parent=root_module['MIRoot'])
    module.add_class('MIBase2', parent=root_module['MIRoot'])
    module.add_class('MIMixed', parent=[root_module['MIBase1'], root_module['MIBase2']])
    module.add_container('SimpleStructList', 'simple_struct_t', container_type='vector')
    module.add_container('std::map< std::string, int >', ('std::string', 'int'), container_type='map')
    module.add_container('std::set< unsigned int >', 'unsigned int', container_type='set')
    module.add_container('std::set< float >', 'float', container_type='set')
    module.add_container('std::vector< simple_struct_t >', 'simple_struct_t', container_type='vector')
    module.add_container('SimpleStructVec', 'simple_struct_t', container_type='vector')
    module.add_container('SimpleStructMap', ('std::string', 'simple_struct_t'), container_type='map')
    module.add_container('std::vector< std::string >', 'std::string', container_type='vector')
    typehandlers.add_type_alias('std::map< std::string, simple_struct_t, std::less< std::string >, std::allocator< std::pair< std::string const, simple_struct_t > > >', 'SimpleStructMap')
    typehandlers.add_type_alias('std::map< std::string, simple_struct_t, std::less< std::string >, std::allocator< std::pair< std::string const, simple_struct_t > > >*', 'SimpleStructMap*')
    typehandlers.add_type_alias('std::map< std::string, simple_struct_t, std::less< std::string >, std::allocator< std::pair< std::string const, simple_struct_t > > >&', 'SimpleStructMap&')
    typehandlers.add_type_alias('std::vector< simple_struct_t, std::allocator< simple_struct_t > >', 'SimpleStructList')
    typehandlers.add_type_alias('std::vector< simple_struct_t, std::allocator< simple_struct_t > >*', 'SimpleStructList*')
    typehandlers.add_type_alias('std::vector< simple_struct_t, std::allocator< simple_struct_t > >&', 'SimpleStructList&')
    typehandlers.add_type_alias('std::vector< simple_struct_t, std::allocator< simple_struct_t > >', 'SimpleStructVec')
    typehandlers.add_type_alias('std::vector< simple_struct_t, std::allocator< simple_struct_t > >*', 'SimpleStructVec*')
    typehandlers.add_type_alias('std::vector< simple_struct_t, std::allocator< simple_struct_t > >&', 'SimpleStructVec&')
    typehandlers.add_type_alias('void ( * ) (  ) *', 'Callback')
    typehandlers.add_type_alias('void ( * ) (  ) **', 'Callback*')
    typehandlers.add_type_alias('void ( * ) (  ) *&', 'Callback&')
    
    ## Register a nested module for the namespace TopNs
    
    nested_module = module.add_cpp_namespace('TopNs')
    register_types_TopNs(nested_module)
    
    
    ## Register a nested module for the namespace std
    
    nested_module = module.add_cpp_namespace('std')
    register_types_std(nested_module)
    
    
    ## Register a nested module for the namespace xpto
    
    nested_module = module.add_cpp_namespace('xpto')
    register_types_xpto(nested_module)
    

def register_types_TopNs(module):
    root_module = module.get_root()
    
    module.add_class('OuterBase')
    
    ## Register a nested module for the namespace PrefixBottomNs
    
    nested_module = module.add_cpp_namespace('PrefixBottomNs')
    register_types_TopNs_PrefixBottomNs(nested_module)
    

def register_types_TopNs_PrefixBottomNs(module):
    root_module = module.get_root()
    
    module.add_class('PrefixInner', parent=root_module['TopNs::OuterBase'])

def register_types_std(module):
    root_module = module.get_root()
    

def register_types_xpto(module):
    root_module = module.get_root()
    
    module.add_enum('FooType', ['FOO_TYPE_AAA', 'FOO_TYPE_BBB', 'FOO_TYPE_CCC'])
    module.add_class('SomeClass')
    typehandlers.add_type_alias('Foo', 'xpto::FooXpto')
    typehandlers.add_type_alias('Foo*', 'xpto::FooXpto*')
    typehandlers.add_type_alias('Foo&', 'xpto::FooXpto&')
    module.add_typedef(root_module['Foo'], 'FooXpto')
    typehandlers.add_type_alias('uint32_t', 'xpto::FlowId')
    typehandlers.add_type_alias('uint32_t*', 'xpto::FlowId*')
    typehandlers.add_type_alias('uint32_t&', 'xpto::FlowId&')

def register_methods(root_module):
    register_AbstractBaseClass_methods(root_module, root_module['AbstractBaseClass'])
    register_AbstractBaseClass2_methods(root_module, root_module['AbstractBaseClass2'])
    register_AbstractBaseClassImpl_methods(root_module, root_module['AbstractBaseClassImpl'])
    register_AbstractXpto_methods(root_module, root_module['AbstractXpto'])
    register_AbstractXptoImpl_methods(root_module, root_module['AbstractXptoImpl'])
    register_Box_methods(root_module, root_module['Box'])
    register_CannotBeConstructed_methods(root_module, root_module['CannotBeConstructed'])
    register_ClassThatTakesFoo_methods(root_module, root_module['ClassThatTakesFoo'])
    register_ClassThatThrows_methods(root_module, root_module['ClassThatThrows'])
    register_Foo_methods(root_module, root_module['Foo'])
    register_Foobar_methods(root_module, root_module['Foobar'])
    register_InterfaceId_methods(root_module, root_module['InterfaceId'])
    register_MIRoot_methods(root_module, root_module['MIRoot'])
    register_ManipulatedObject_methods(root_module, root_module['ManipulatedObject'])
    register_MapLike_methods(root_module, root_module['MapLike'])
    register_PointerHolder__Zbr_methods(root_module, root_module['PointerHolder< Zbr >'])
    register_ProtectedConstructor_methods(root_module, root_module['ProtectedConstructor'])
    register_ReferenceManipulator_methods(root_module, root_module['ReferenceManipulator'])
    register_SingletonClass_methods(root_module, root_module['SingletonClass'])
    register_Socket_methods(root_module, root_module['Socket'])
    register_SomeObject_methods(root_module, root_module['SomeObject'])
    register_SomeObjectNestedClass_methods(root_module, root_module['SomeObject::NestedClass'])
    register_TestContainer_methods(root_module, root_module['TestContainer'])
    register_Tupl_methods(root_module, root_module['Tupl'])
    register_UdpSocket_methods(root_module, root_module['UdpSocket'])
    register_VectorLike_methods(root_module, root_module['VectorLike'])
    register_VectorLike2_methods(root_module, root_module['VectorLike2'])
    register_Word_methods(root_module, root_module['Word'])
    register_Zbr_methods(root_module, root_module['Zbr'])
    register_Zoo_methods(root_module, root_module['Zoo'])
    register_Property__StdString_methods(root_module, root_module['property< std::string >'])
    register_Simple_struct_t_methods(root_module, root_module['simple_struct_t'])
    register_Bar_methods(root_module, root_module['Bar'])
    register_MIBase1_methods(root_module, root_module['MIBase1'])
    register_MIBase2_methods(root_module, root_module['MIBase2'])
    register_MIMixed_methods(root_module, root_module['MIMixed'])
    register_TopNsOuterBase_methods(root_module, root_module['TopNs::OuterBase'])
    register_TopNsPrefixBottomNsPrefixInner_methods(root_module, root_module['TopNs::PrefixBottomNs::PrefixInner'])
    register_XptoSomeClass_methods(root_module, root_module['xpto::SomeClass'])
    return

def register_AbstractBaseClass_methods(root_module, cls):
    cls.add_constructor([param('AbstractBaseClass const &', 'arg0')])
    cls.add_constructor([], 
                        visibility='protected')
    cls.add_method('do_something', 
                   'void', 
                   [param('char * * * *', 'arg0')], 
                   is_pure_virtual=True, visibility='protected', is_virtual=True)
    return

def register_AbstractBaseClass2_methods(root_module, cls):
    cls.add_method('invoke_private_virtual', 
                   'int', 
                   [param('int', 'x')], 
                   is_const=True)
    cls.add_method('invoke_protected_pure_virtual', 
                   'int', 
                   [param('int', 'x')], 
                   is_const=True)
    cls.add_method('invoke_protected_virtual', 
                   'int', 
                   [param('int', 'x')], 
                   is_const=True)
    cls.add_constructor([], 
                        visibility='protected')
    cls.add_method('protected_pure_virtual', 
                   'int', 
                   [param('int', 'x')], 
                   is_pure_virtual=True, is_const=True, visibility='protected', is_virtual=True)
    cls.add_method('protected_virtual', 
                   'int', 
                   [param('int', 'x')], 
                   is_const=True, visibility='protected', is_virtual=True)
    cls.add_method('private_virtual', 
                   'int', 
                   [param('int', 'x')], 
                   is_pure_virtual=True, is_const=True, visibility='private', is_virtual=True)
    return

def register_AbstractBaseClassImpl_methods(root_module, cls):
    cls.add_constructor([param('AbstractBaseClassImpl const &', 'arg0')])
    cls.add_method('get_abstract_base_class_ptr1', 
                   retval('AbstractBaseClass *', caller_owns_return=True), 
                   [], 
                   is_static=True)
    cls.add_method('get_abstract_base_class_ptr2', 
                   retval('AbstractBaseClass *', caller_owns_return=False), 
                   [], 
                   is_static=True)
    cls.add_constructor([], 
                        visibility='protected')
    cls.add_method('do_something', 
                   'void', 
                   [param('char * * * *', 'arg0')], 
                   visibility='protected', is_virtual=True)
    return

def register_AbstractXpto_methods(root_module, cls):
    cls.add_constructor([param('AbstractXpto const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('something', 
                   'void', 
                   [param('int', 'x')], 
                   is_pure_virtual=True, is_const=True, is_virtual=True)
    return

def register_AbstractXptoImpl_methods(root_module, cls):
    cls.add_constructor([param('AbstractXptoImpl const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('something', 
                   'void', 
                   [param('int', 'x')], 
                   is_const=True, is_virtual=True)
    return

def register_Box_methods(root_module, cls):
    cls.add_static_attribute('instance_count', 'int', is_const=False)
    cls.add_instance_attribute('m_internalFoobar', retval('Foobar *', return_internal_reference=True), is_const=False)
    cls.add_constructor([])
    cls.add_method('getFoobarInternalPtr', 
                   retval('Foobar *', reference_existing_object=True), 
                   [])
    cls.add_method('getFoobarInternalRef', 
                   retval('Foobar &', reference_existing_object=True), 
                   [])
    cls.add_method('getFoobarInternalPtr2', 
                   retval('Foobar *', return_internal_reference=True), 
                   [])
    cls.add_method('getFoobarInternalRef2', 
                   retval('Foobar &', return_internal_reference=True), 
                   [])
    return

def register_CannotBeConstructed_methods(root_module, cls):
    cls.add_constructor([param('CannotBeConstructed const &', 'arg0')])
    cls.add_method('get_ptr', 
                   retval('CannotBeConstructed *', caller_owns_return=True), 
                   [], 
                   is_static=True)
    cls.add_method('get_value', 
                   'CannotBeConstructed', 
                   [], 
                   is_static=True)
    return

def register_ClassThatTakesFoo_methods(root_module, cls):
    cls.add_constructor([param('ClassThatTakesFoo const &', 'arg0')])
    cls.add_constructor([param('Foo', 'foo')])
    cls.add_method('get_foo', 
                   'Foo', 
                   [], 
                   is_const=True)
    return

def register_ClassThatThrows_methods(root_module, cls):
    cls.add_constructor([param('ClassThatThrows const &', 'arg0')])
    cls.add_constructor([param('double', 'x')], 
                        throw=[root_module['DomainError']])
    cls.add_method('my_inverse_method', 
                   'double', 
                   [param('double', 'x')], 
                   throw=[root_module['DomainError']])
    cls.add_method('my_inverse_method2', 
                   'double', 
                   [param('double', 'x')], 
                   throw=[root_module['std::exception']])
    cls.add_method('throw_error', 
                   'int', 
                   [], 
                   is_const=True, throw=[root_module['std::exception']], is_virtual=True)
    return

def register_Foo_methods(root_module, cls):
    cls.add_output_stream_operator()
    cls.add_constructor([])
    cls.add_constructor([param('int', 'xpto')])
    cls.add_constructor([param('std::string const &', 'datum')])
    cls.add_constructor([param('Foo const &', 'other')])
    cls.add_method('add_sub', 
                   'int', 
                   [param('int', 'a'), param('int', 'b', default_value='3'), param('bool', 'subtract', default_value='false')], 
                   is_static=True)
    cls.add_method('get_datum', 
                   'std::string const', 
                   [], 
                   is_const=True)
    cls.add_method('get_datum_deprecated', 
                   'std::string', 
                   [], 
                   is_const=True)
    cls.add_method('initialize', 
                   'void', 
                   [])
    cls.add_method('is_initialized', 
                   'bool', 
                   [], 
                   is_const=True)
    cls.add_static_attribute('instance_count', 'int', is_const=False)
    return

def register_Foobar_methods(root_module, cls):
    cls.add_static_attribute('instance_count', 'int', is_const=False)
    cls.add_constructor([])
    return

def register_InterfaceId_methods(root_module, cls):
    cls.add_constructor([param('InterfaceId const &', 'arg0')])
    return

def register_MIRoot_methods(root_module, cls):
    cls.add_constructor([param('MIRoot const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('root_method', 
                   'int', 
                   [], 
                   is_const=True)
    return

def register_ManipulatedObject_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_method('GetValue', 
                   'int', 
                   [], 
                   is_const=True)
    cls.add_method('SetValue', 
                   'void', 
                   [param('int', 'value')])
    return

def register_MapLike_methods(root_module, cls):
    cls.add_constructor([param('MapLike const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('Begin', 
                   'std::_Rb_tree_iterator< std::pair< int const, double > >', 
                   [])
    cls.add_method('End', 
                   'std::_Rb_tree_iterator< std::pair< int const, double > >', 
                   [])
    cls.add_method('set', 
                   'void', 
                   [param('int', 'key'), param('double', 'value')])
    return

def register_PointerHolder__Zbr_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('PointerHolder< Zbr > const &', 'arg0')])
    cls.add_instance_attribute('thePointer', 'Zbr *', is_const=False)
    return

def register_ProtectedConstructor_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('ProtectedConstructor &', 'arg0')], 
                        visibility='protected')
    return

def register_ReferenceManipulator_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_method('do_manipulate_object', 
                   'void', 
                   [param('ManipulatedObject &', 'obj', direction=3)], 
                   is_pure_virtual=True, is_virtual=True)
    cls.add_method('manipulate_object', 
                   'int', 
                   [])
    return

def register_SingletonClass_methods(root_module, cls):
    cls.add_constructor([param('SingletonClass const &', 'arg0')])
    cls.add_method('GetInstance', 
                   retval('SingletonClass *', caller_owns_return=True), 
                   [], 
                   is_static=True)
    return

def register_Socket_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('Socket const &', 'arg0')])
    cls.add_method('Bind', 
                   'int', 
                   [], 
                   is_virtual=True)
    cls.add_method('Bind', 
                   'int', 
                   [param('int', 'address')], 
                   is_virtual=True)
    return

def register_SomeObject_methods(root_module, cls):
    cls.add_constructor([param('SomeObject const &', 'other')])
    cls.add_constructor([param('std::string const', 'prefix')])
    cls.add_constructor([param('int', 'prefix_len')])
    cls.add_method('add_prefix', 
                   'int', 
                   [param('std::string &', 'message', direction=3)])
    cls.add_method('call_get_prefix', 
                   'std::string', 
                   [], 
                   is_const=True)
    cls.add_method('get_foo_by_ref', 
                   'void', 
                   [param('Foo &', 'foo', direction=2)])
    cls.add_method('get_foo_ptr', 
                   retval('Foo *', caller_owns_return=True), 
                   [])
    cls.add_method('get_foo_shared_ptr', 
                   retval('Foo *', caller_owns_return=False), 
                   [])
    cls.add_method('get_foo_value', 
                   'Foo', 
                   [])
    cls.add_method('get_foobar_with_other_as_custodian', 
                   retval('Foobar *', custodian=1, reference_existing_object=True), 
                   [param('SomeObject *', 'other', transfer_ownership=False)])
    cls.add_method('get_foobar_with_self_as_custodian', 
                   retval('Foobar *', custodian=0, reference_existing_object=True), 
                   [])
    cls.add_method('get_int', 
                   'int', 
                   [param('char const *', 'from_string')])
    cls.add_method('get_int', 
                   'int', 
                   [param('double', 'from_float')])
    cls.add_method('get_internal_zbr', 
                   retval('Zbr *', caller_owns_return=True), 
                   [])
    cls.add_method('get_prefix', 
                   'std::string', 
                   [], 
                   is_const=True, is_virtual=True)
    cls.add_method('get_prefix_with_foo_ptr', 
                   'std::string', 
                   [param('Foo const *', 'foo')], 
                   is_const=True, is_virtual=True)
    cls.add_method('get_prefix_with_foo_ref', 
                   'std::string', 
                   [param('Foo const &', 'foo', direction=3)], 
                   is_const=True, is_virtual=True)
    cls.add_method('get_prefix_with_foo_value', 
                   'std::string', 
                   [param('Foo', 'foo')], 
                   is_const=True, is_virtual=True)
    cls.add_method('get_pyobject', 
                   retval('PyObject *', caller_owns_return=True), 
                   [], 
                   is_virtual=True)
    cls.add_method('get_something', 
                   'std::string', 
                   [], 
                   is_const=True, is_virtual=True)
    cls.add_method('get_something', 
                   'std::string', 
                   [param('int', 'x')], 
                   is_const=True, is_virtual=True)
    cls.add_method('get_zbr', 
                   retval('Zbr *', caller_owns_return=True), 
                   [])
    cls.add_method('get_zbr_pholder', 
                   'PointerHolder< Zbr >', 
                   [])
    cls.add_method('peek_zbr', 
                   retval('Zbr *', caller_owns_return=False), 
                   [])
    cls.add_method('set_foo_by_ref', 
                   'void', 
                   [param('Foo const &', 'foo')])
    cls.add_method('set_foo_ptr', 
                   'void', 
                   [param('Foo *', 'foo', transfer_ownership=True)])
    cls.add_method('set_foo_shared_ptr', 
                   'void', 
                   [param('Foo *', 'foo', transfer_ownership=False)])
    cls.add_method('set_foo_value', 
                   'void', 
                   [param('Foo', 'foo')])
    cls.add_method('set_foobar_with_self_as_custodian', 
                   'void', 
                   [param('Foobar *', 'foobar', custodian=0, transfer_ownership=True)])
    cls.add_method('set_pyobject', 
                   'void', 
                   [param('PyObject *', 'pyobject', transfer_ownership=False)], 
                   is_virtual=True)
    cls.add_method('set_zbr_pholder', 
                   'void', 
                   [param('PointerHolder< Zbr >', 'zbr')])
    cls.add_method('set_zbr_shared', 
                   'void', 
                   [param('Zbr *', 'zbr', transfer_ownership=False)])
    cls.add_method('set_zbr_transfer', 
                   'void', 
                   [param('Zbr *', 'zbr', transfer_ownership=True)])
    cls.add_method('operator()', 
                   'int', 
                   [param('std::string &', 'message', direction=3)], 
                   custom_name='__call__')
    cls.add_static_attribute('instance_count', 'int', is_const=False)
    cls.add_instance_attribute('m_prefix', 'std::string', is_const=False)
    cls.add_static_attribute('staticData', 'std::string', is_const=False)
    cls.add_method('protected_method_that_is_not_virtual', 
                   'std::string', 
                   [param('std::string', 'arg')], 
                   is_const=True, visibility='protected')
    return

def register_SomeObjectNestedClass_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('std::string', 'datum')])
    cls.add_constructor([param('SomeObject::NestedClass const &', 'other')])
    cls.add_method('get_datum', 
                   'std::string', 
                   [], 
                   is_const=True)
    cls.add_static_attribute('instance_count', 'int', is_const=False)
    return

def register_TestContainer_methods(root_module, cls):
    cls.add_constructor([param('TestContainer const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('get_simple_list', 
                   'SimpleStructList', 
                   [], 
                   is_virtual=True)
    cls.add_method('get_simple_map', 
                   'SimpleStructMap', 
                   [], 
                   is_virtual=True)
    cls.add_method('get_simple_vec', 
                   'SimpleStructVec', 
                   [], 
                   is_virtual=True)
    cls.add_method('get_vec', 
                   'void', 
                   [param('std::vector< std::string > &', 'outVec', direction=2)])
    cls.add_method('get_vec_ptr', 
                   'void', 
                   [param('std::vector< std::string > *', 'outVec', direction=2)])
    cls.add_method('set_simple_list', 
                   'int', 
                   [param('SimpleStructList', 'list')], 
                   is_virtual=True)
    cls.add_method('set_simple_list_by_ref', 
                   'int', 
                   [param('SimpleStructList &', 'inout_list', direction=3)], 
                   is_virtual=True)
    cls.add_method('set_simple_map', 
                   'int', 
                   [param('SimpleStructMap', 'map')], 
                   is_virtual=True)
    cls.add_method('set_simple_vec', 
                   'int', 
                   [param('SimpleStructVec', 'vec')], 
                   is_virtual=True)
    cls.add_method('set_vec_ptr', 
                   'void', 
                   [param('std::vector< std::string > *', 'inVec', transfer_ownership=True, direction=1)])
    cls.add_instance_attribute('m_floatSet', 'std::set< float >', is_const=False)
    return

def register_Tupl_methods(root_module, cls):
    cls.add_inplace_numeric_operator('+=', param('int', 'right'))
    cls.add_inplace_numeric_operator('+=', param('Tupl const &', 'right'))
    cls.add_binary_comparison_operator('>')
    cls.add_binary_numeric_operator('+', root_module['Tupl'], root_module['Tupl'], param('Tupl const &', 'right'))
    cls.add_binary_numeric_operator('-', root_module['Tupl'], root_module['Tupl'], param('Tupl const &', 'right'))
    cls.add_binary_comparison_operator('<')
    cls.add_inplace_numeric_operator('*=', param('Tupl const &', 'right'))
    cls.add_inplace_numeric_operator('-=', param('Tupl const &', 'right'))
    cls.add_inplace_numeric_operator('/=', param('Tupl const &', 'right'))
    cls.add_binary_comparison_operator('<=')
    cls.add_binary_comparison_operator('>=')
    cls.add_binary_comparison_operator('!=')
    cls.add_binary_numeric_operator('*', root_module['Tupl'], root_module['Tupl'], param('Tupl const &', 'right'))
    cls.add_unary_numeric_operator('-')
    cls.add_binary_numeric_operator('/', root_module['Tupl'], root_module['Tupl'], param('Tupl const &', 'right'))
    cls.add_binary_comparison_operator('==')
    cls.add_constructor([])
    cls.add_constructor([param('Tupl const &', 'arg0')])
    cls.add_instance_attribute('x', 'int', is_const=False)
    cls.add_instance_attribute('y', 'int', is_const=False)
    return

def register_UdpSocket_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('UdpSocket const &', 'arg0')])
    cls.add_method('Bind', 
                   'int', 
                   [], 
                   is_virtual=True)
    return

def register_VectorLike_methods(root_module, cls):
    cls.add_constructor([param('VectorLike const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('Begin', 
                   '__gnu_cxx::__normal_iterator< double *, std::vector< double > >', 
                   [])
    cls.add_method('End', 
                   '__gnu_cxx::__normal_iterator< double *, std::vector< double > >', 
                   [])
    cls.add_method('append', 
                   'void', 
                   [param('double', 'value')])
    cls.add_method('get_item', 
                   'double', 
                   [param('size_t', 'index')], 
                   is_const=True, custom_name='__getitem__')
    cls.add_method('get_len', 
                   'size_t', 
                   [], 
                   is_const=True, custom_name='__len__')
    cls.add_method('set_item', 
                   'void', 
                   [param('size_t', 'index'), param('double', 'value')], 
                   custom_name='__setitem__')
    return

def register_VectorLike2_methods(root_module, cls):
    cls.add_constructor([param('VectorLike2 const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('Begin', 
                   '__gnu_cxx::__normal_iterator< double *, std::vector< double > >', 
                   [])
    cls.add_method('End', 
                   '__gnu_cxx::__normal_iterator< double *, std::vector< double > >', 
                   [])
    cls.add_method('append', 
                   'void', 
                   [param('double', 'value')])
    return

def register_Word_methods(root_module, cls):
    cls.add_instance_attribute('low', 'uint8_t', is_const=False)
    cls.add_instance_attribute('high', 'uint8_t', is_const=False)
    cls.add_constructor([])
    cls.add_constructor([param('Word const &', 'arg0')])
    cls.add_instance_attribute('word', 'uint16_t', is_const=False)
    return

def register_Zbr_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('std::string', 'datum')])
    cls.add_constructor([param('Zbr const &', 'other')])
    cls.add_method('get_datum', 
                   'std::string', 
                   [], 
                   is_const=True)
    cls.add_method('get_int', 
                   'int', 
                   [param('int', 'x')], 
                   is_virtual=True)
    cls.add_method('get_value', 
                   'int', 
                   [param('int *', 'foobaz', transfer_ownership=True, direction=2)])
    cls.add_static_attribute('instance_count', 'int', is_const=False)
    return

def register_Zoo_methods(root_module, cls):
    cls.add_constructor([param('Zoo const &', 'arg0')])
    cls.add_constructor([])
    cls.add_constructor([param('std::string', 'datum')])
    cls.add_method('get_datum', 
                   'std::string', 
                   [], 
                   is_const=True)
    return

def register_Property__StdString_methods(root_module, cls):
    cls.add_constructor([param('property< std::string > const &', 'arg0')])
    cls.add_constructor([])
    return

def register_Simple_struct_t_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('simple_struct_t const &', 'arg0')])
    cls.add_instance_attribute('xpto', 'int', is_const=False)
    return

def register_Bar_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('Bar const &', 'arg0')])
    cls.add_method('Hooray', 
                   'std::string', 
                   [], 
                   is_static=True)
    return

def register_MIBase1_methods(root_module, cls):
    cls.add_constructor([param('MIBase1 const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('base1_method', 
                   'int', 
                   [], 
                   is_const=True)
    return

def register_MIBase2_methods(root_module, cls):
    cls.add_constructor([param('MIBase2 const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('base2_method', 
                   'int', 
                   [], 
                   is_const=True)
    return

def register_MIMixed_methods(root_module, cls):
    cls.add_constructor([param('MIMixed const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('mixed_method', 
                   'int', 
                   [], 
                   is_const=True)
    return

def register_TopNsOuterBase_methods(root_module, cls):
    cls.add_constructor([])
    cls.add_constructor([param('TopNs::OuterBase const &', 'arg0')])
    return

def register_TopNsPrefixBottomNsPrefixInner_methods(root_module, cls):
    cls.add_constructor([param('TopNs::PrefixBottomNs::PrefixInner const &', 'arg0')])
    cls.add_constructor([])
    cls.add_method('Do', 
                   'void', 
                   [])
    return

def register_XptoSomeClass_methods(root_module, cls):
    cls.add_constructor([param('xpto::SomeClass const &', 'arg0')])
    cls.add_constructor([])
    return

def register_functions(root_module):
    module = root_module
    module.add_function('TypeNameGet', 
                        'std::string', 
                        [], 
                        custom_name='IntegerTypeNameGet', template_parameters=['int'])
    module.add_function('create_new_foobar', 
                        retval('Foobar *', caller_owns_return=True), 
                        [])
    module.add_function('delete_some_object', 
                        'void', 
                        [])
    module.add_function('delete_stored_zbr', 
                        'void', 
                        [])
    module.add_function('function_that_returns_foo', 
                        'Foo', 
                        [])
    module.add_function('function_that_takes_callback', 
                        'void', 
                        [param('Callback', 'cb')])
    module.add_function('function_that_takes_foo', 
                        'void', 
                        [param('Foo', 'foo')])
    module.add_function('get_abstract_base_class_ptr1', 
                        retval('AbstractBaseClass *', caller_owns_return=True), 
                        [])
    module.add_function('get_abstract_base_class_ptr2', 
                        retval('AbstractBaseClass *', caller_owns_return=False), 
                        [])
    module.add_function('get_cannot_be_constructed_ptr', 
                        retval('CannotBeConstructed *', caller_owns_return=True), 
                        [])
    module.add_function('get_cannot_be_constructed_value', 
                        'CannotBeConstructed', 
                        [])
    module.add_function('get_foobar_with_other_as_custodian', 
                        retval('Foobar *', custodian=1, reference_existing_object=True), 
                        [param('SomeObject *', 'other', transfer_ownership=False)])
    module.add_function('get_hidden_subclass_pointer', 
                        retval('Foo *', caller_owns_return=True), 
                        [])
    module.add_function('get_int_from_float', 
                        'int', 
                        [param('double', 'from_float'), param('int', 'multiplier', default_value='1')], 
                        custom_name='get_int')
    module.add_function('get_int_from_string', 
                        'int', 
                        [param('char const *', 'from_string'), param('int', 'multiplier', default_value='1')], 
                        custom_name='get_int')
    module.add_function('get_map', 
                        'std::map< std::string, int >', 
                        [])
    module.add_function('get_set', 
                        'std::set< unsigned int >', 
                        [])
    module.add_function('get_simple_list', 
                        'SimpleStructList', 
                        [])
    module.add_function('invoke_some_object_get_prefix', 
                        'std::string', 
                        [])
    module.add_function('invoke_zbr', 
                        'int', 
                        [param('int', 'x')])
    module.add_function('make_interface_id', 
                        'InterfaceId', 
                        [])
    module.add_function('matrix_identity_new', 
                        'void', 
                        [param('float *', 'matrix', direction=2, array_length=6)])
    module.add_function('matrix_sum_of_elements', 
                        'float', 
                        [param('float *', 'matrix', direction=1, array_length=6)])
    module.add_function('my_inverse_func', 
                        'double', 
                        [param('double', 'x')], 
                        throw=[root_module['DomainError']])
    module.add_function('my_inverse_func2', 
                        'double', 
                        [param('double', 'x')], 
                        throw=[root_module['std::exception']])
    module.add_function('print_something', 
                        'int', 
                        [param('char const *', 'message')])
    module.add_function('print_something_else', 
                        'int', 
                        [param('char const *', 'message2')])
    module.add_function('set_foobar_with_other_as_custodian', 
                        'void', 
                        [param('Foobar *', 'foobar', custodian=2, transfer_ownership=True), param('SomeObject *', 'other', transfer_ownership=False)])
    module.add_function('set_foobar_with_return_as_custodian', 
                        retval('SomeObject *', caller_owns_return=True), 
                        [param('Foobar *', 'foobar', custodian=-1, transfer_ownership=True)])
    module.add_function('set_simple_list', 
                        'int', 
                        [param('SimpleStructList', 'list')])
    root_module['SomeObject'].add_function_as_method('some_object_get_something_prefixed', 'std::string', [param('SomeObject const *', 'obj', transfer_ownership=False), param('std::string const', 'something')], custom_name='get_something_prefixed')
    root_module['SomeObject'].add_function_as_method('some_object_ref_get_something_prefixed', 'std::string', [param('SomeObject const &', 'obj'), param('std::string const', 'something')], custom_name='ref_get_something_prefixed')
    root_module['SomeObject'].add_function_as_method('some_object_val_get_something_prefixed', 'std::string', [param('SomeObject', 'obj'), param('std::string const', 'something')], custom_name='val_get_something_prefixed')
    module.add_function('store_some_object', 
                        'void', 
                        [param('SomeObject *', 'obj', transfer_ownership=True)])
    module.add_function('store_zbr', 
                        'void', 
                        [param('Zbr *', 'zbr', transfer_ownership=True)])
    module.add_function('take_some_object', 
                        retval('SomeObject *', caller_owns_return=True), 
                        [])
    register_functions_TopNs(module.get_submodule('TopNs'), root_module)
    register_functions_std(module.get_submodule('std'), root_module)
    register_functions_xpto(module.get_submodule('xpto'), root_module)
    return

def register_functions_TopNs(module, root_module):
    register_functions_TopNs_PrefixBottomNs(module.get_submodule('PrefixBottomNs'), root_module)
    return

def register_functions_TopNs_PrefixBottomNs(module, root_module):
    return

def register_functions_std(module, root_module):
    return

def register_functions_xpto(module, root_module):
    module.add_function('get_flow_id', 
                        'xpto::FlowId', 
                        [param('xpto::FlowId', 'flowId')])
    module.add_function('get_foo_datum', 
                        'std::string', 
                        [param('xpto::FooXpto const &', 'foo')])
    module.add_function('get_foo_type', 
                        'xpto::FooType', 
                        [])
    module.add_function('set_foo_type', 
                        'void', 
                        [param('xpto::FooType', 'type')])
    module.add_function('set_foo_type_inout', 
                        'void', 
                        [param('xpto::FooType &', 'type', direction=3)])
    module.add_function('set_foo_type_ptr', 
                        'void', 
                        [param('xpto::FooType *', 'type', direction=3)])
    module.add_function('some_function', 
                        'std::string', 
                        [])
    return

def main():
    out = FileCodeSink(sys.stdout)
    root_module = module_init()
    register_types(root_module)
    register_methods(root_module)
    register_functions(root_module)
    root_module.generate(out)

if __name__ == '__main__':
    main()

