CREATE TABLE IF NOT EXISTS `ioconf_analogs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `boardname` varchar(255) NOT NULL,
  `boardip` varchar(15) NOT NULL,
  `ananum` smallint(6) NOT NULL DEFAULT '1',
  `status_num` enum('1','2','3','4') NOT NULL DEFAULT '1',
  `status_name` varchar(32) NOT NULL DEFAULT 'DEFAULT',
  `enabled` enum('yes','no') NOT NULL DEFAULT 'no',
  `anatype` int(5) unsigned NOT NULL DEFAULT '0',
  `mintime` int(5) unsigned NOT NULL DEFAULT '1',
  `minval` int(11) NOT NULL DEFAULT '0',
  `maxval` int(11) NOT NULL DEFAULT '1023',
  `continuos_domain` varchar(32) NOT NULL,
  `continuos_msg` int(5) unsigned NOT NULL DEFAULT '0',
  `continuos_ctx` int(5) unsigned NOT NULL DEFAULT '0',
  `continuos_act` int(5) unsigned NOT NULL DEFAULT '0',
  `continuos_time` int(6) NOT NULL DEFAULT '1',
  `continuos_opt` int(5) unsigned NOT NULL DEFAULT '0',
  `continuos_optstring` varchar(64) NOT NULL,
  `continuos_dst` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `min_domain` varchar(32) NOT NULL,
  `min_msg` int(5) unsigned NOT NULL DEFAULT '0',
  `min_ctx` int(5) unsigned NOT NULL DEFAULT '0',
  `min_act` int(5) unsigned NOT NULL DEFAULT '0',
  `min_level` int(6) NOT NULL DEFAULT '1',
  `min_opt` int(5) unsigned NOT NULL DEFAULT '0',
  `min_optstring` varchar(64) NOT NULL,
  `min_dst` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `max_domain` varchar(32) NOT NULL,
  `max_msg` int(5) unsigned NOT NULL DEFAULT '0',
  `max_ctx` int(5) unsigned NOT NULL DEFAULT '0',
  `max_act` int(5) unsigned NOT NULL DEFAULT '0',
  `max_level` int(6) NOT NULL DEFAULT '1',
  `max_opt` int(5) unsigned NOT NULL DEFAULT '0',
  `max_optstring` varchar(64) NOT NULL,
  `max_dst` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `enables` (`enabled`),
  KEY `boardname` (`boardname`),
  KEY `boardip` (`boardip`),
  KEY `status_num` (`status_num`),
  KEY `status_name` (`status_name`),
  KEY `anatype` (`anatype`),
  KEY `ananum` (`ananum`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `ioconf_inputs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `boardname` varchar(255) NOT NULL,
  `boardip` varchar(15) NOT NULL,
  `inpnum` smallint(6) NOT NULL DEFAULT '0',
  `status_num` enum('1','2','3','4') NOT NULL DEFAULT '1',
  `status_name` varchar(32) NOT NULL DEFAULT 'DEFAULT',
  `enabled` enum('yes','no') NOT NULL DEFAULT 'no',
  `inptype` int(5) unsigned NOT NULL DEFAULT '0',
  `mintime` int(5) unsigned NOT NULL DEFAULT '1',
  `act1_domain` varchar(32) NOT NULL,
  `act1_msg` int(5) unsigned NOT NULL DEFAULT '0',
  `act1_ctx` int(5) unsigned NOT NULL DEFAULT '0',
  `act1_act` int(5) unsigned NOT NULL DEFAULT '0',
  `act1_time` int(6) NOT NULL DEFAULT '1',
  `act1_opt` int(5) unsigned NOT NULL DEFAULT '0',
  `act1_optstring` varchar(64) NOT NULL,
  `act1_dst` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `act2_domain` varchar(32) NOT NULL,
  `act2_msg` int(5) unsigned NOT NULL DEFAULT '0',
  `act2_ctx` int(5) unsigned NOT NULL DEFAULT '0',
  `act2_act` int(5) unsigned NOT NULL DEFAULT '0',
  `act2_level` int(6) NOT NULL DEFAULT '1',
  `act2_opt` int(5) unsigned NOT NULL DEFAULT '0',
  `act2_optstring` varchar(64) NOT NULL,
  `act2_dst` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `act3_domain` varchar(32) NOT NULL,
  `act3_msg` int(5) unsigned NOT NULL DEFAULT '0',
  `act3_ctx` int(5) unsigned NOT NULL DEFAULT '0',
  `act3_act` int(5) unsigned NOT NULL DEFAULT '0',
  `act3_level` int(6) NOT NULL DEFAULT '1',
  `act3_opt` int(5) unsigned NOT NULL DEFAULT '0',
  `act3_optstring` varchar(64) NOT NULL,
  `act3_dst` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `enables` (`enabled`),
  KEY `boardname` (`boardname`),
  KEY `boardip` (`boardip`),
  KEY `status_num` (`status_num`),
  KEY `status_name` (`status_name`),
  KEY `anatype` (`inptype`),
  KEY `inpnum` (`inpnum`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `ioconf_outputs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `boardname` varchar(255) NOT NULL,
  `boardip` varchar(15) NOT NULL,
  `outnum` smallint(6) NOT NULL DEFAULT '0',
  `enabled` enum('yes','no') NOT NULL DEFAULT 'no',
  `outtype` int(5) unsigned NOT NULL DEFAULT '0',
  `ctx` int(5) unsigned NOT NULL DEFAULT '0',
  `startime` int(5) unsigned NOT NULL DEFAULT '50',
  `opentime` int(5) unsigned NOT NULL DEFAULT '300',
  `pausetime` int(5) NOT NULL DEFAULT '50',
  `bang` enum('yes','no') NOT NULL DEFAULT 'no',
  `r1_relay` int(5) unsigned NOT NULL DEFAULT '0',
  `r1_def` enum('NC','NO','SAVE') NOT NULL DEFAULT 'NO',
  `r1_duration` int(5) unsigned NOT NULL DEFAULT '0',
  `r1_retard` int(5) unsigned NOT NULL DEFAULT '0',
  `r1_tollerance` int(5) unsigned NOT NULL DEFAULT '0',
  `r1_rearm` int(5) unsigned NOT NULL DEFAULT '0',
  `r1_ampere` int(3) unsigned NOT NULL DEFAULT '80',
  `r2_relay` int(5) unsigned NOT NULL DEFAULT '0',
  `r2_def` enum('NC','NO','SAVE') NOT NULL DEFAULT 'NO',
  `r2_duration` int(5) unsigned NOT NULL DEFAULT '0',
  `r2_retard` int(5) unsigned NOT NULL DEFAULT '0',
  `r2_tollerance` int(5) unsigned NOT NULL DEFAULT '0',
  `r2_rearm` int(5) unsigned NOT NULL DEFAULT '0',
  `r2_ampere` int(3) unsigned NOT NULL DEFAULT '80',
  PRIMARY KEY (`id`),
  KEY `enables` (`enabled`),
  KEY `boardname` (`boardname`),
  KEY `boardip` (`boardip`),
  KEY `anatype` (`outtype`),
  KEY `outnum` (`outnum`),
  KEY `ctx` (`ctx`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `ioconf_pwm` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

ALTER TABLE  `user_gui_panels` CHANGE  `panel_type`  `panel_type` ENUM(  'standard',  'gauge',  'thermostat',  'graph',  'macrobuttons',  'bookmarks',  'cameras',  'video',  'gxv3175_left',  'gxv3175_center',  'gxv3175_right' ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT  'standard';
