###########################################################################
# Copyright (c) 2018- Franco (nextime) Lanza <franco@unixmedia.it>
#
# Penguidom System Controller Daemon "penguidomd" 
#
# This file is part of penguidomd.
#
# penguidomd is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from twisted.application import service
from twisted.internet import defer, reactor, task, protocol, threads
from nexlibs.utils.genutils import configFile, FakeObject, ConvenienceCaller
from nexlibs.utils import genutils
import logging, sys, os
import subprocess
import time, copy
from twisted.web import microdom as xml
from nexlibs.utils import webutils as wu
from dmlib import constants as C
import time
from txscheduling import task  as txcron
from txscheduling.cron import CronSchedule, parseCronLine
from txscheduling.interfaces import ISchedule
from netifaces import interfaces, ifaddresses, AF_INET
import struct
from dmlib import dmdomain

from singleton import Singleton
import ikap


try:
   import hashlib
   md5 = hashlib
   md5.new = hashlib.md5
   sha1 = hashlib.sha1
except:
   import md5
   import sha1


ALLIP=C.IKAP_BROADCAST

ACTION_STATUS={}


log = logging.getLogger( 'Core' )

class penguidomService(service.Service):

   initialized=False
   udp=False
   tcp=False

   def __init__(self, *args, **kwargs):
      log.info('Initializing Core')
      self.curdir=kwargs['curdir']
      self.config=kwargs['config']
      sys.path.append(self.curdir+"/penguidom")
      log.debug('Current dir: '+self.curdir)
      if self.parent:
         self.parent.__new__(self.parent, self, *args)

   def _callback(self, who, cmd, *args, **kwargs):
      """
         The callback that try to find an appropriate method exported
         to a higher level object by the ConvenienceCaller metaclass.

         This isn't intended to be called by the user directly, instead pass it
         to the instance of the higher level object initialization or by
         setting it using the abstraction of the ConvenienceCaller metaclass
      """
      try:
         try:
            f=getattr(self, who+'_on_'+cmd)
         except:
            f=getattr(self, 'on_'+cmd)
         if f and callable(f):
            return f
      except:
         raise AttributeError(" ".join([cmd, 'doesn\'t exists']))


   def isStarted(self):
      log.debug("isStarted() called")
      self.isConfigured()


   def isConfigured(self):
      self.initialized=True
      log.debug("isConfigured() called")

   def getIkapUDP(self):
      caller = ConvenienceCaller(lambda c: self._callback('ikap', c))
      self.udp = ikap.DomIkaUDP(caller)
      return self.udp

   def getIkapTCP(self):
      caller = ConvenienceCaller(lambda c: self._callback('ikap', c))
      self.tcp = ikap.DomIkaServerFactory(caller)
      return self.tcp

   def on_configGet(self, section, var):
      return self.config.get(section, var)

