###########################################################################
# Copyright (c) 2018- Franco (nextime) Lanza <franco@nexlab.it>
#
# Penguidom System client Daemon "penguidomd"  [https://git.nexlab.net/domotika/Penguidom]
#
# This file is part of penguidom.
#
# penguidom is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from penguidom import imodules
from zope.interface import implements
from twisted.plugin import IPlugin

from twisted.internet.serialport import SerialPort
from twisted.internet.protocol import BaseProtocol
from twisted.internet import reactor
import serial
import time

SERIAL_PORT="/dev/ttyUSB0"
BAUDRATE=9600
PKTTIMEOUT=2 # Seconds


def checkSumCalc(message):
   checksum = 0
   return chr(sum(map(ord, m)) % 256)


def checkSumTest(message):
   if len(message) == 37:
      if message[36] == checkSumCalc(message[:36])
         return True
   return False

def format37ByteMessage(message):
   checksum = 0
   message = message.ljust(36, '\x00')
   if len(message) % 37 != 0:
      message += checkSumCalc(message) # Add check to end of message
   return message


class ParadoxProtocol(BaseProtocol):


   packet=[]
   queue=[]
   packettimeout = 0
   waitreply = 0

   def __init__(self, logger, core):
      self.log = logger
      self.core = core

   def _queueData(self):
      if len(self.packet) >= 37:
         if self.waitreply > 0:
            self.waitreply-=1
         packet="".join(self.packet[:37])
         self.log.debug("MESSAGE QUEUED: "+''.join( [ "\\x%02X" % ord( x ) for x in packet ] ).strip()) #+str(packet).encode("hex"))
         print packet
         self.queue+=[packet]
         self.packet=self.packet[37:]
         reactor.callLater(0, self._queueData)
         reactor.callLater(0, self._processQueue)
      elif len(self.packet) > 0:
         self.packettimeout = time.time()
         
  
   def _processQueue(self):
      pass
    
   def dataReceived(self, data):
      if len(self.packet) > 0 and (time.time()-self.packettimeout) > PKTTIMEOUT:
         self.log.debug("Serial Timeout: discard packet "+''.join( [ "\\x%02X" % ord( x ) for x in self.packet ] ).strip())
         self.packet = []
      self.packet+=list(data)
      self._queueData()


   def connectionMade(self):
      self.log.info("Serial port correctly connected")
      self.login()

   def login(self):
      #message = '\x72\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
      message = '\x72'
      self.write(message)

      message = '\x50\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
      self.write(message)

      message = '\x5f\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
      self.write(message)

   def write(self, message):
      if self.waitreply == 0:
         self.transport.write(format37ByteMessage(message))
         self.waitreply+=1
      else:
         reactor.callLater(0, self.write, message)
         

class Paradox(object):
   implements(IPlugin, imodules.IModules)

   def _openSerial(self, port=SERIAL_PORT, retry=3):
      if retry > 0:
         try:
            self.port = SerialPort(ParadoxProtocol(self.log, self.core), port, reactor, baudrate=BAUDRATE)
         except serial.SerialException as err:
            self.log.info("Serial Port ERROR: "+str(err))
            reactor.callLater(1, self._openSerial, port, retry-1)
         
      else:
         self.log.info("Unable to open Serial Port: retry in 1 minute")
         reactor.callLater(60, self._openSerial, port)

   def initialize(self, callback, logger):
      self.log = logger
      self.core = callback
      logger.info("Initialize Serial Connection...")
      self._openSerial()
      logger.info("Plugin initialized")



