###########################################################################
# Copyright (c) 2018- Franco (nextime) Lanza <franco@nexlab.it>
#
# Penguidom System client Daemon "penguidomd"  [https://git.nexlab.net/domotika/Penguidom]
#
# This file is part of penguidom.
#
# penguidom is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################
from nexlibs.singleton import Singleton


class ParadoxEventMap(Singleton):
    
   eventMap = {}

   def __init__(self, *args, **kwargs):
      Singleton.__init__( self )

   def loadEvents(self, eventmap):
      self.eventMap = eventmap


   def getEventGroupDescription(self, eg):
      try:
         return self.eventMap.eventGroupMap[eg]
      except KeyError:
         print "No ParadoxMap for: eg=%d"%(eg)
         return "-"

   def getSubEventGroupDescription(self, eg, seg):
      try:
         return self.eventMap.subEventGroupMap[eg][seg]
      except KeyError:
         print "No ParadoxMap for: eg=%d \t seg=%d"%(eg,seg)
         return "-"

   def getEventDescription(self, eg, seg):
      try:
         return self.eventMap.eventGroupMap[eg], self.eventMap.subEventGroupMap[eg][seg]
      except KeyError:
         print "No ParadoxMap for: eg=%d \t seg=%d" % (eg, seg)
         return "-"

   def getLabelTypeDescription(self, lt):
      return self.eventMap.labelTypeMap[lt]

   def setzoneLabel(self, number, value):
      self.eventMap._zoneLabel.update({number: value})
      return

   def getzoneLabel(self, number):
      value = self.eventMap._zoneLabel[number]
      return value

   def getAllzoneLabel(self):
      return self.eventMap._zoneLabel

   def setuserLabel(self, number, value):
      self.eventMap._userLabel.update({number: value})
      return
    
   def getAlluserLabel(self):
      return self.eventMap._userLabel
    
   def setpartitionLabel(self, number, value):
      self.eventMap._partitionLabel.update({number: value})
      return
    
   def getAllpartitionLabel(self):
      return self.eventMap._partitionLabel
    
   def setbusModuleLabel(self, number, value):
      self.eventMap._busModuleLabel.update({number: value})
      return
    
   def getbusModuleLabel(self, number):
      value = self.eventMap._busModuleLabel[number]
      return value
    
   def getAllbusModuleLabel(self):
      return self.eventMap._busModuleLabel
    
   def setwirelessRepeaterLabel(self, number, value):
      self.eventMap._wirelessRepeater.update({number: value})
      return
    
   def getwirelessRepeaterLabel(self, number):
      value = self.eventMap._wirelessRepeater[number]
      return value
    
   def getAllwirelessRepeaterLabel(self):
      return self.eventMap._wirelessRepeater
   
   def setwirelessKeypadLabel(self, number, value):
      self.eventMap._wirelessKeypad.update({number: value})
      return
    
   def getwirelessKeypadLabel(self, number):
      value = self.eventMap._wirelessKeypad[number]
      return value
    
   def getAllwirelessKeypadLabel(self):
      return self.eventMap._wirelessKeypad
    
   def setsiteNameLabel(self, number, value):
      self.eventMap._siteNameLabel.update({number: value})
      return
    
   def setwirelessSirenLabel(self, number, value):
      self.eventMap._wirelessSiren.update({number: value})
      return
    
   def getwirelessSirenLabel(self, number):
      value = self.eventMap._wirelessSiren[number]
      return value
    
   def getAllwirelessSirenLabel(self):
      return self.eventMap._wirelessSiren

   def setoutputLabel(self, number, value):
      self.eventMap._outputLabel.update({number: value})
      return
    
   def getoutputLabel(self, number):
      value = self.eventMap._outputLabel[number]
      return value
    
   def getAlloutputLabel(self):
      return self.eventMap._outputLabel


class ParadoxRegisters(Singleton):
    
   registers = {}

   def __init__(self, *args, **kwargs):
      Singleton.__init__( self )

   def loadRegisters(self, register):
      self.registers = register

   def getzoneLabelRegister(self):
      return self.registers.zoneLabel
    
   def getpartitionLabelRegister(self):
      return self.registers.partitionLabel
    
   def getuserLabelRegister(self):
      return self.registers.userLabel
    
   def getbusModuleLabelRegister(self):
      return self.registers.busModuleLabel
    
   def getwirelessRepeaterLabelRegister(self):
      return self.registers.wirelessRepeaterLabel
    
   def getwirelessKeypadLabelRegister(self):
      return self.registers.wirelessKeypadLabel
    
   def getsiteNameLabelRegister(self):
      return self.registers.siteNameLabel
    
   def getwirelessSirenLabelRegister(self):
      return self.registers.wirelessSirenLabel
    
   def getoutputLabelRegister(self):
      return self.registers.outputLabel
    
   def getcontrolOutputRegister(self):
      return self.registers.controlOutput
    
   def getsupportedItems(self):
      return self.registers.supportedItems


def getParadoxEventMap():
   return ParadoxEventMap.getInstance()

def getParadoxRegisters():
   return ParadoxRegisters.getInstance()


EVENTMAP = getParadoxEventMap()
REGISTERS = getParadoxRegisters()
