###########################################################################
# Copyright (c) 2018- Franco (nextime) Lanza <franco@nexlab.it>
#
# Penguidom System client Daemon "penguidomd"  [https://git.nexlab.net/domotika/Penguidom]
#
# This file is part of penguidom.
#
# penguidom is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

import logging
import os, sys
import imodules, plugins
from nexlibs.utils.genutils import ConvenienceCaller
from nexlibs.utils import genutils
from ConfigParser import NoSectionError

log = logging.getLogger('Plugins')

try:
   from twisted.plugin import IPlugin, getPlugins
except ImportError:
   pass
else:
   list(getPlugins(imodules.IModules, plugins)) # To refresh cache


PLUGINDIR=os.path.join(os.path.abspath(os.path.dirname(sys.argv[0])), 'penguidom', 'plugins')


def getPlugin(name, core=False):
   for p in getPlugins(imodules.IModules, plugins):
      qual = "%s.%s" % (p.__module__, p.__class__.__name__)
      log.info("Loading plugin "+qual)
      if p.__module__.split('.')[-1]==name:
         p.core = core
         return p
   return None


class PluginLogger(object):

   def __init__(self, plugname):
      self.name = plugname

   def _format(self, what):
      return str(self.name)+": "+what

   def info(self, what):
      log.info(self._format(what))

   def error(self, what):
      log.error(self._format(what))

   def warning(self, what):
      log.warning(self._format(what))

   def debug(self, what):
      log.debug(self._format(what))


class Loader(object):

   plugreg = {}

   def __init__(self, core):
      log.info("Initializing Plugins...")
      self.core = core
      for name in os.listdir(PLUGINDIR):
         plugpath = "/".join([PLUGINDIR, name])
         if os.path.isdir(plugpath):
            try:
               if genutils.isTrue(self.core.configGet('plugins', name)):
                  p = getPlugin(name, core)
                  self.plugreg[name] = p
                  p.initialize(ConvenienceCaller(lambda c: self._plugincback(name, c)), PluginLogger(name))
            except NoSectionError:
               log.error("Trying to load "+name+" plugin but no value in config file plugins section")


   def _plugincback(self, who, cmd, *args, **kwargs):
      """
         The callback that try to find an appropriate method exported
         to a higher level object by the ConvenienceCaller metaclass.

         This isn't intended to be called by the user directly, instead pass it
         to the instance of the higher level object initialization or by
         setting it using the abstraction of the ConvenienceCaller metaclass
      """
      try:
         try:
            f=getattr(self, who+'_on_'+cmd)
         except:
            try:
               f=getattr(self, 'on_'+cmd)
            except:
               f=getattr(self.core, cmd)
         if f and callable(f):
            return f
      except:
         raise AttributeError(" ".join([cmd, 'doesn\'t exists']))

