from ConfigParser import SafeConfigParser

class configFile(SafeConfigParser):

   def __init__(self, config):
      self.configfile = config
      SafeConfigParser.__init__(self)

   def readConfig(self):
      return self.read(self.configfile)

   def writeConfig(self):
      fd = open(self.configfile, "w")
      self.write(fd)
      fd.close()
      return True


   def getOptions(self, section):
      res = {}
      for opt in self.items(section):
         try:
            res[opt[0]] = opt[1]
         except:
            pass
      return res


def getMonth(y, m, tz=None):
   import calendar as cal
   import datetime
   import pytz
   days = {} 
   for d in cal.Calendar().itermonthdates(int(y), int(m)):
      if d.year == int(y) and d.month == int(m):
         dt=datetime.datetime(d.year, d.month, d.day, 0, 0, tzinfo=pytz.timezone("UTC"))
         if not tz: 
            tz='UTC'
         start=int(dt.astimezone(pytz.timezone(str(tz))).strftime("%s"))
         stop=start+86399
         days[int(str(y)+str(m).zfill(2)+str(d.day).zfill(2))] = (start, stop)
   dkeys=days.keys()
   dkeys.sort()
   start=days[dkeys[0]][0]
   stop=days[dkeys[-1]][1]
   return start, stop, days
