from twisted.web import client
from twisted.internet import defer, reactor, task
import logging
from BeautifulSoup import BeautifulSoup

log = logging.getLogger("Observatory")


class dome:

   status = 'Unknown'
   oldstatus = 'Unknown'

   def __init__(self):
      log.debug("Starting Looping to set PEDARA Wheather status")
      self.ccall = task.LoopingCall(self.getStatus)

   def startCron(self, timeout=10):
      try:
         self.ccall.stop()
      except:
         pass
      self.ccall.start(timeout)

   def stopCron(self):
      log.debug("Calling stopCron for PEDARA dome")
      try:
         self.ccall.stop()
      except:
         pass
      self.status = 'Unknown'
      self.oldstatus = 'Unknown'
      try:
         self.command('DStatus', 'pedara')
      except:
         pass

   def getStatus(self):
      return client.getPage("http://www.skylive.it/status.txt").addCallback(self.setStatus
            ).addErrback(lambda _: log.debug("Error setting status for PEDARA dome"))

   def setStatus(self, res):
      if res:
         try:
            self.first = True
            statsplit = res.split("\r\n")[:3]
            sensori = {}
            for sens in statsplit:
               k, v = sens.split(" : ")
               sensori[k.split(" ")[1]]=v
            if len(sensori) > 0:
               try:
                  if sensori['chiuso'] == 'Aperto' and sensori['aperto'] == 'Chiuso':
                     self.status='Open'
                  else:
                     self.status='Closed'
               except:
                  log.debug("PEDARA: error setting sensors")
                  self.status='Unknown'
         except:
            log.debug("PEDARA: error splitting result")
            self.status = 'Unknown'
      else:
         # try two times before to set unknown because of no result
         if self.first:
            self.first = False
         else:
            self.status = 'Unknown'
            self.first = True
      try:
         if self.oldstatus != self.status:
            self.oldstatus = self.status
            self.command('DStatus', 'pedara')
            log.warning("Setting status "+self.status+" for PEDARA dome")
      except:
         pass
      return defer.succeed(True)

class wheather:

   status = 'Unknown'
   oldstatus = 'Unknown'   

   def __init__(self):
      log.debug("Starting Looping to set PEDARA Wheather status")
      self.ccall = task.LoopingCall(self.getStatus)

   def startCron(self, timeout=5):
      try:
         self.ccall.stop()
      except:
         pass
      self.ccall.start(timeout)

   def stopCron(self):
      log.debug("Calling stopCron for PEDARA wheather")
      try:
         self.ccall.stop()
      except:
         pass
      self.status = 'Unknown'
      self.oldstatus = 'Unknown'
      try:
         self.command('WStatus', 'pedara')
      except:
         pass

   def getStatus(self):
      return client.getPage("http://www.skylive.it/status.txt").addCallback(self.setStatus
            ).addErrback(lambda _: log.debug("Error setting status for PEDARA weather"))

   def setStatus(self, res):
      if res:
         self.first = True
         try:
            statsplit = res.split("\r\n")[:3]
            sensori = {}
            for sens in statsplit:
               k, v = sens.split(" : ")
               sensori[k.split(" ")[1]]=v
            if len(sensori) > 0:
               try:
                  if sensori['pioggia'] == 'Non Piove':
                     self.status='Clean'
                  else:
                     self.status='Rain'
               except:
                  self.status='Unknown'
         except:
            self.status = 'Unknown'
      else:
         # try two times before to set unknown because of no result
         if self.first:
            self.first = False
         else:
            self.status = 'Unknown'
            self.first = True

      try:
         if self.oldstatus != self.status:
            self.oldstatus = self.status
            self.command('WStatus', 'pedara')
            log.warning("Setting status "+self.status+" for PEDARA wheather")
      except:
         pass
      return defer.succeed(True)

