import lx200codes as codes
import logging

log = logging.getLogger("Lx200")


class lx200Parser:

   def __init__(self):
      pass

   def __call__(self, antani):
      self.__init__()

   def parseMsg(self, msg, *args, **kwargs):
      act = {}
      log.debug("ARRIVATO DAL TELE: "+str(msg))
      if msg[:4] == 'AUTH':
         cmd, usr, pwd = msg.split('|')
         act[cmd] = {'usr': usr, 'pwd': pwd}
      elif msg[:4] == 'PING':
         act['PING'] = True
      elif msg[:7] == 'CCDTEMP':
         act['setCCDTEMP'] = msg[7:]
      elif msg == 'PhotoNo':
         # inizia l'upload della foto dopo l'esposizione
         act['sendPhotoNo'] = True
         
      elif msg == 'PhotoYes':
         # XXX ricordiamo di mettere Xerr e Yerr a 0 dopo la fine della foto!
         # finito l'upload della foto dopo l'esposizione
         act['sendPhotoYes'] = True
      elif msg == 'Started':
         act['telescopeStarted'] = True
      elif msg == 'Stopped':
         act['telescopeStopped'] = True
      elif msg.split('*', 1)[0] == 'AFSTEP':
         act['setFWHM'] = msg.split('*', 1)[1]
      elif msg.split('*', 1)[0] == 'AFSTART':
         act['setFWHM'] = msg.split('*', 1)[1]
         act['autoFocusStart'] = True
      elif msg.split('*', 1)[0] == 'AFSTART':
         act['setFWHM'] = msg.split('*', 1)[1]
         act['autoFocusStop'] = True

      elif msg == 'SYNCSTART':
         act['syncStart'] = True

      elif msg in ['ROOFCLOSED', 'ROOFOPEN']:
         act[msg] = True

      elif msg.split('*', 1)[0] == 'SYNCSTOP':
         act['syncStop'] = msg.split('*', 1)[1]

      elif msg.split('*', 1)[0] == 'GETRADEC':
         act['getRaDec'] = msg.split('*', 1)[1]

      elif msg.split(':', 1)[0] == 'Object':
         try:
            act['recObject'] = '---'
            if not msg.split(':', 1)[1] == '':
               act['recObject'] = msg.split(':', 1)[1]
         except:
            act['recObject'] = 'Error'
      elif msg.split(':', 1)[0] == 'GuideError':
         try:
            Xerr, Yerr = msg.split(':', 1)[1].split('|')
            act['recGuideError'] = [ Xerr, Yerr ]
         except:
            pass
      else:
         try:
            if len(msg) == 13 and (msg[7:8:] == '-' or msg[7:8:] == '+'):
               act['setPOSITION'] = msg
         except:
            pass
      return act


def cmdFormat(msg, *args):
   if len(args) > 0:
      msg=msg+"*"+"*".join(args)
   return "Comando="+msg+"*"

def reqauth():
   return "AUTH"

def moveCARDINAL(where):
   return cmdFormat('cmd'+where.capitalize())

def movePLANETS(code, name):
   return cmdFormat('cmdPianeta', 'Codiceoggetto='+code, 'Descrizione='+name)

def moveMESSIER(which):
   return cmdFormat('cmdMessier', 'Messier#='+codes.getMessier(which), 'Descrizione='+which)

def moveCNGC(which):
   return cmdFormat('cmdCngc', 'Codiceoggetto='+codes.getCngc(which), 'Descrizione='+which)

def moveARDEC(ar, dec, desc=False):
   dec=dec.replace(":", ".")
   if not desc:
      desc = 'RA'+ar+' DEC '+dec
   return cmdFormat('cmdMuovi', 'ComandoAR='+ar, 'ComandoDEC='+dec, 'Descrizione='+desc )

def centre(centre):
   return cmdFormat('cmdCentra', 'Codiceoggetto='+centre)

def FOTO( esp, codestr, username):
   return cmdFormat('cmdFoto', 'Tempoesposizione='+esp, 'Dark='+codestr, 'Messier='+username)

def STOPFOTO():
   # XXX non ancora implementato su LX200
   pass

def SETCCDTemp(temp):
   return "CCDTempSet="+str(temp)

def AUTOFOCUS():
   return 'AUTOFOCUS'

def FOCUSPLUS():
   return 'FOCUS+'

def FOCUSLESS():
   return 'FOCUS-'

def getFWHM():
   return 'GETFWHM'

def SYNC():
   return 'SYNC'

def PONG():
   return 'PONG'

def radec(ra=False, dec=False):
   if ra and dec:
      return 'PUTRADEC'+str(ra)+"*"+str(dec)
   else:
      return 'PUTRADECFALSE'
def authok():
   return 'OKAUTH'
