from lang import lang

planets = {
   'mercury': '0901',
   'venus': '0902',
   'moon': '0903',
   'mars': '0904',
   'jupiter': '0905',
   'saturn': '0906',
   'uranus': '0907',
   'neptune': '0908',
   'pluto': '0909'
}

def getPlanet(name):
   rname = name.lower()
   if lang.en_key_exists(rname):
      rname = lang.it2en(rname)
   try:
      return planets[rname]
   except:
      return name


def getMessier(name):
   return name[1:]

def getCngc(name):
   return name[4:]

def getIc(name):
   return name[2:]
