from twisted.web import resource, static
from twisted.python import reflect
import cgi, logging
from nevow import inevow, rend, tags, loaders, flat
import os, sys
import registration



log = logging.getLogger("Webgui")
curdir=os.path.abspath(os.path.dirname(sys.argv[0]))
template_path = curdir+'/Web/html/Guest/'

class Page(rend.Page):
   
   addSlash = True
   guestchilds = ['registration', 'comet']

   def renderHTTP( self, ctx):
      log.debug("Rendering Permission Denied")
      request = inevow.IRequest(ctx)
      request.setHeader('Location', '/__logout__')
      request.setResponseCode(302)
      html = '<html><head><title>SkyLive Daemon</title></head>'
      html = html+"<b>i can't find the requested page  or "
      html = html+" you don't have permission to view this page!</b></br>"
      html = html+'</body></html>'
      return html


   def __init__(self, avatarId=None):
      self.avatarId = avatarId
      log.debug("Requested Userlist by "+str(avatarId))
      rend.Page.__init__(self)

   def childFactory(self, ctx, name):
      if name in self.guestchilds:

         try:
            f = reflect.namedAny('Web.WGuest.'+name)
            return self.onChildCall(ctx, f)
         except:
            log.debug("No guest child found")
      return self.childPermissionDenied()

   def ChildAddCommons(self, child):
      log.debug("Adding common calls to the guest child")
      child.render_HEADER = self.render_HEADER
      child.render_FOOTER = self.render_FOOTER
      child.render_HEAD = self.render_HEAD
      child.render_translator = self.render_translator
      child.data_translator = self.data_translator
      child.command = self.command
      child.parent = self
      try:
         child.sess = self.sess
      except:
         child.sess = None
      child.avatarId = self.avatarId
      child.childPermissionDenied = self.childPermissionDenied
      child.template_path = self.template_path
      return child

   def onChildCall(self, ctx, page):
      p = page.Page(self.avatarId)
      p = self.ChildAddCommons(p)
      return p

