#!/usr/bin/env python2.5
from zope.interface import Interface, implements
from axiom import item, attributes, store
from pysqlite2 import dbapi2
from epsilon import extime
import time
import md5

con =  dbapi2.connect("skylive.db")
cur = con.cursor()
cur.execute("SELECT * FROM Users")
rows = cur.fetchall()


# costo orario e ore utente


class ISkyliveUsers(Interface):
   """ ISkyliveUsers Interface """

class SkyliveUsers(item.Item):
   
   implements(ISkyliveUsers)

   typeName = "SkyliveUsers"

   nome = attributes.text(allowNone=True, indexed=True)
   cognome = attributes.text(allowNone=True, indexed=True)
   telescopio = attributes.boolean(default=False)
   preferenza = attributes.text(allowNone=True)
   giudizio = attributes.text(allowNone=True)
   email = attributes.text(allowNone=False, indexed=True)
   citta = attributes.text(allowNone=True)
   nazione = attributes.text(allowNone=True)
   username = attributes.text(allowNone=False, indexed=True)
   password = attributes.text(allowNone=False, indexed=True)
   admin = attributes.boolean(default=False, indexed=True)
   lingua = attributes.text(default="it", indexed=True)
   tsiscrizione = attributes.timestamp(indexed=True)
   lastlogin = attributes.timestamp(indexed=True, allowNone=True)
   active = attributes.boolean(default=False, indexed=True)
   uniqueid = attributes.text(allowNone=False, indexed=True)
   hourtypes = attributes.textlist(allowNone=False, indexed=True, default=['default'])
   banned = attributes.boolean(indexed=True, default=False)
   mlist = attributes.boolean(indexed=True, default=True)
   privacycommercial = attributes.boolean(indexed=True, default=True)
   privacydefault = attributes.boolean(indexed=True, default=True)

   def updateLastLogin(self):
      self.lastlogin = extime.Time.fromPOSIXTimestamp(time.time())


class IUserSubscriptions(Interface):
   """ UserSubscriptions Interface """

class UserSubscriptions(item.Item):

   implements(IUserSubscriptions)

   schemaVersion = 2

   typeName = 'UserSubscriptions'
   username = attributes.text(allowNone=False, indexed=True)
   subname = attributes.text(allowNone=False, indexed=True)
   price = attributes.money(default=100)
   expiration = attributes.timestamp(indexed=True)
   expireadvised = attributes.boolean(default=False, indexed=True)


class ISubscriptionsType(Interface):
   """ SubscriptionsType Interface """

class SubscriptionsType(item.Item):

   implements(ISubscriptionsType)

   typeName = 'SubscriptionsType'
   name = attributes.text(allowNone=False, indexed=True)
   telescopes = attributes.textlist(allowNone=False)
   price = attributes.money(default=100)
   duration = attributes.integer(default=12)
   public = attributes.boolean(default=False, indexed=True)


class IBannedIP(Interface):
   """ BannedIP Interface """

class BannedIP(item.Item):

   implements(IBannedIP)

   typeName = 'BannedIP'

   address = attributes.text(allowNone=False, indexed=True)
   cause = attributes.text(default='Unknown cause')
   bannedby = attributes.text(indexed=True)
   bannedwhen = attributes.timestamp(indexed=True)

class IHoursPayement(Interface):
   """ HoursPayement Interface """

class HoursPayement(item.Item):

   implements(IHoursPayement)

   typeName = 'HoursPayement'

   username = attributes.text(indexed=True, allowNone=False)
   date = attributes.timestamp(indexed=True, allowNone=False)
   hourstype = attributes.text(indexed=True, allowNone=False)
   hours = attributes.integer(default=0)


class IUserHours(Interface):
   """ UserHours Interface """

class UserHours(item.Item):

   implements(IUserHours)

   typeName = 'UserHours'

   username = attributes.text(indexed=True, allowNone=False)
   hourstype = attributes.text(indexed=True, allowNone=False)
   hours = attributes.integer(default=0)

class IHoursTypes(Interface):
   """ HoursTypes Interface """

class HoursTypes(item.Item):

   implements(IHoursTypes)

   typeName = 'HoursType'

   name = attributes.text(allowNone=False, indexed=True)
   telescopes = attributes.textlist(allowNone=False)
   price = attributes.money(default=100)
   candistribute = attributes.boolean(default=False)
   mounthlimit = attributes.integer(allowNone=True, default=None)
   minpack = attributes.integer(default=1)
   startlimit  = attributes.integer(allowNone=True, default=None)
   stoplimit = attributes.integer(allowNone=True, default=None)

class IMontlyHours(Interface):
   """  MontlyHours Interface """

class MontlyHours(item.Item):
   
   implements(IMontlyHours)

   typeName = 'MontlyHours'

   username = attributes.text(allowNone=False, indexed=True)
   howmany = attributes.integer(default=1)
   hourstype = attributes.text(indexed=True, allowNone=False)

class ITelescopeBooking(Interface):
   """ TelescopeBooking Interface """

class TelescopeBooking(item.Item):

   implements(ITelescopeBooking)

   typeName = 'TelescopeBooking'

   telescope = attributes.integer(allowNone=False, indexed=True)
   username = attributes.text(allowNone=False, indexed=True)
   allowedusers = attributes.textlist(allowNone=False, indexed=True)
   timestart = attributes.timestamp(indexed=True, allowNone=False)
   timestop = attributes.timestamp(indexed=True, allowNone=False)
   used = attributes.boolean(default=False, indexed=True)
   hourstype = attributes.text(indexed=True, allowNone=False)


def upgradeUserSubscriptions(oldsub):
   return oldsub.upgradeVersion('UserSubscriptions', 1, 2,
                                 username=oldsub.username,
                                 subname=oldsub.subname,
                                 price=oldsub.price,
                                 expiration=oldsub.expiration,
                                 expireadvised=False)

from axiom.upgrade import registerUpgrader
registerUpgrader(upgradeUserSubscriptions, 'UserSubscriptions', 1, 2)
s = store.Store('../AxiomDB')

