#!/usr/bin/python
import os,sys

curdir = os.path.abspath(os.path.dirname(sys.argv[0])).replace('/scripts', '')
sys.path.append(curdir)

from skyliveDaemon.decra import decra as DECRA


long = '149:21:56'
lat = '-33:49:52'
obsName = 'GCO'
DECRA.setUtcDiff(0)
DECRA.setObsData(long, lat, obsName)


def run():
   objReq = None
   selected = False
   print 'Land Position (ALT = 0 AZ = East) = ', DECRA.getLandPos()
   while not selected:
      print 'Please select search mode:\n1 for skyliveNG protocol mode.\n2 for Type / ObjName Mode.\n3 for ALT AZ search by RA DEC.'
      sel = raw_input('Mode ? : ')
      if sel == '1' or sel == '2' or sel == '3':
         selected = True
      else:
         pass
   while objReq != 'exit':
      if sel == '1':
         objReq = raw_input('OBJ ? : ')
         if objReq != 'exit':
            result = DECRA.getDECRAbyCMD(objReq)
            if result['result'] == 'unknow':
               print 'Unknown OBJ'
            elif result['result'] == 'noObj':
               print 'No OBJ Search'
            else:
               print 'Dict obj : ', result
      elif sel == '2':
         what = raw_input('Obj Type (m, ngc, planet, star or exit)? : ')
         if what == 'exit':
            break
         who = raw_input('Obj Name (for messier or ngc only id number)? : ')
         if what.upper() in ['M', 'NGC', 'PLANET', 'STAR']:
            result = DECRA.getDECRAbyLIST([what, who])
            if result['result'] == 'unknow':
               print 'Unknown OBJ'
            elif result['result'] == 'noObj':
               print 'No OBJ Search'
            else:
               print 'Dict obj : ', result
      elif sel == '3':
         ra = raw_input('Please insert RA (xx:xx.x or exit) : ')
         if ra == 'exit':
            break
         dec = raw_input('Please insert DEC (xx.xx) : ')
         result = DECRA.getALTAZbyRADEC(ra, dec)
         print result
    

if __name__ == "__main__":
   print 'decra test script, avaiable NGC, Messier, Planets and Bright Stars OBJ \nType "exit" to quit'
   run()
