// import Nevow.Athena
// import Divmod
// import Divmod.Runtime
// import QxLoader
// import SkyliveGui

SkyClient.Server = Nevow.Athena.Widget.subclass("SkyClient.Server");

SkyClient.Server.methods(
 
   function __init__(self, node) {
       SkyClient.Server.upcall(self, '__init__', node);
       qxl = new QxLoader.Runner();
       qxl.start();
       self.qxApp = qx.core.Init.getApplication();
   },

   function sendChat(self, data, dest) {
      if(typeof dest == 'string') {
         self.callRemote('sendChat', data, dest);
      } else {
         self.callRemote('sendChat', data, dest.toString());
      }
      return data;
   },


   function getUserList(self) {
      self.callRemote('getUserList');
   },

   function getUsername(self) {
      return self.callRemote('getUsername');
   },

   function on_updateUserList(self, ulist) {
      self.qxApp.userListReceived(ulist);
   },

   function exitTelescope(self, tnum, presence) {
      self.callRemote('exitClient', telescope=tnum, presence=presence);
   },

   function on_chatMessage(self, arg1, arg2) {

      //alert(arg1+' '+arg2);
      //qxApp = qx.core.Init.getApplication();
      //qxApp.chatarea.setHtml(qxApp.chatarea.getHtml()+arg2+' > '+arg1+'<br />');
      //self.qxApp = qx.core.Init.getApplication();
      self.qxApp.chatReceived(arg1, arg2);
   },

   function on_privMessage(self, msg, sender) {
      self.qxApp.privReceived(msg, sender);
   }

);

//qxl = new QooXdoo.Gui();
//qxl.start();
