"""
     Copyright (C) 2007-2009 Franco Lanza <nextime@nexlab.it>
     Copyright (C) 2007-2009 Sandro Aliano <ita595@hotmail.com>
     Copyright (C) 2007-2009 Ivan Bellia <skylive@skylive.it>

     Web site: http://www.astronomix.org/trac/Skylive-NG

     This file is part of Skylive-NG.

     Skylive-NG is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     Skylive-NG is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Skylive-NG.  If not, see <http://www.gnu.org/licenses/>.
"""
import os

def rmdir(dir):
   for root, dirs, files in os.walk(dir, topdown=False):
      for name  in files:
         os.remove(os.path.join(root, name))
      for name in dirs:
         os.rmdir(os.path.join(root, name))

def is_eeepc():
   # xandros seem to don't have hald... how we can do?
   #return True
   if os.path.isfile('/sys/class/dmi/id/board_serial'):
      try:
         # hal-get-property --udi '/org/freedesktop/Hal/devices/computer'
         # --key system.hardware.serial
         f=os.popen4('hal-get-property --udi "/org/freedesktop/Hal/devices/computer" --key system.hardware.serial')
         res = f[1].read(5)
         f[1].close()
         f[0].close()
         if res == 'EeePC':
            return True
      except:
         pass
   return False


def is_frozen():
   import imp, sys
   return (hasattr(sys, "importers")
            or imp.is_frozen("__main__")
            or hasattr(sys, "frozen")
          )

def platform():
   import wx
   plat = wx.PlatformInfo
   if '__WXMAC__' in plat:
      return 'Darwin'
   if '__WXGTK__' in plat:
      # And other gtk?
      return 'Linux'
   if '__WXMSW__' in plat:
      return 'Windows'
   else:
      # By default get Linux
      return 'Linux'
