"""
     Copyright (C) 2007-2009 Franco Lanza <nextime@nexlab.it>
     Copyright (C) 2007-2009 Sandro Aliano <ita595@hotmail.com>
     Copyright (C) 2007-2009 Ivan Bellia <skylive@skylive.it>

     Web site: http://www.astronomix.org/trac/Skylive-NG

     This file is part of Skylive-NG.

     Skylive-NG is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     Skylive-NG is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with Skylive-NG.  If not, see <http://www.gnu.org/licenses/>.
"""
import en
import os, sys
class Language:
   
   def on_initialize(self, event):
      pass
   
   def setLang(self, select):
      try:
         path = os.path.normpath('skylive/lang')
         if not path in sys.path:
            sys.path.append(path)
         #usrLang = __import__(select)
         langmod = __import__('skylive.lang', globals(), locals(), [select], -1)
         usrLang = getattr(langmod, select)
         self.langDict = usrLang.getLang()
      except:
         self.langDict = en.getLang()
      self.excLang = en.getLang()
   
   def findGui(self, gui):
      if self.langDict[gui]:
         guiDict = self.langDict[gui]
      else:
         guiDict = self.excLang[gui]
      return guiDict

   def findItemText(self, lang= False, gui=False, item=False):
      if lang and gui and item:
         self.setLang(lang)
         try:
            itemText = self.findGui(gui)[item]
         except:
            itemText = self.excLang[gui][item]
         return itemText
      else:
         return False

Lang = Language()

def getItemText(lang=False, gui=False, item=False):
   return Lang.findItemText(lang, gui, item)
